/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.amqp;

import com.chutneytesting.action.amqp.ConnectionFactoryFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public class AmqpCleanQueuesAction
implements Action {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final List<String> queueNames;
    private final Logger logger;

    public AmqpCleanQueuesAction(Target target, @Input(value="queue-names") List<String> queueNames, Logger logger) {
        this.target = target;
        this.queueNames = Optional.ofNullable(queueNames).orElse(Collections.emptyList());
        this.logger = logger;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.targetValidation((Target)this.target), ActionValidatorsUtils.notEmptyListValidation(this.queueNames, (String)"queueNames")});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ActionExecutionResult execute() {
        try (Connection connection = this.connectionFactoryFactory.newConnection(this.target);){
            ActionExecutionResult actionExecutionResult;
            block15: {
                Channel channel = connection.createChannel();
                try {
                    for (String queueName : this.queueNames) {
                        AMQP.Queue.PurgeOk purgeOk = channel.queuePurge(queueName);
                        this.logger.info("Purge queue " + queueName + ". " + purgeOk.getMessageCount() + " messages deleted");
                    }
                    actionExecutionResult = ActionExecutionResult.ok();
                    if (channel == null) break block15;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return actionExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return ActionExecutionResult.ko();
        }
    }
}

