/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.http;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class HttpsListenerAction
implements Action {
    private static final int DEFAULT_MESSAGE_COUNT = 1;
    private final Logger logger;
    private WireMockServer httpsServer;
    private final String uri;
    private final String verb;
    private final int expectedMessageCount;

    public HttpsListenerAction(Logger logger, @Input(value="https-server") WireMockServer httpsServer, @Input(value="uri") String uri, @Input(value="verb") String verb, @Input(value="expected-message-count") String expectedMessageCount) {
        this.logger = logger;
        this.httpsServer = httpsServer;
        this.uri = uri;
        this.verb = verb;
        this.expectedMessageCount = NumberUtils.toInt((String)expectedMessageCount, (int)1);
    }

    public ActionExecutionResult execute() {
        FindRequestsResult result = this.httpsServer.findRequestsMatching(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.fromString((String)this.verb), (UrlPattern)WireMock.urlMatching((String)this.uri)).build());
        int requestReceived = result.getRequests().size();
        if (requestReceived < this.expectedMessageCount) {
            this.logger.error("Expected " + this.expectedMessageCount + " message(s). Receive only " + requestReceived + " message(s)");
            return ActionExecutionResult.ko();
        }
        this.httpsServer.resetRequests();
        return ActionExecutionResult.ok(HttpsListenerAction.toOutputs(result.getRequests()));
    }

    private static Map<String, Object> toOutputs(List<LoggedRequest> request) {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("requests", request);
        return outputs;
    }
}

