/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jms;

import com.chutneytesting.action.jms.JmsConnectionFactory;
import com.chutneytesting.action.jms.UncheckedJmsException;
import com.chutneytesting.action.jms.consumer.Consumer;
import com.chutneytesting.action.jms.consumer.JmsListenerParameters;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.lang3.ArrayUtils;

public class JmsListenerAction
implements Action {
    private final Target target;
    private final Logger logger;
    private final JmsListenerParameters listenerJmsParameters;
    private final JmsConnectionFactory jmsConnectionFactory = new JmsConnectionFactory();

    public JmsListenerAction(Target target, Logger logger, @Input(value="listenerJmsParameters") JmsListenerParameters listenerJmsParameters) {
        this.target = target;
        this.logger = logger;
        this.listenerJmsParameters = listenerJmsParameters;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])((Validator[])ArrayUtils.add((Object[])JmsListenerParameters.validateJmsListenerParameters(this.listenerJmsParameters), (Object)ActionValidatorsUtils.targetValidation((Target)this.target))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionExecutionResult execute() {
        try (CloseableResource<Consumer> consumerCloseableResource = this.jmsConnectionFactory.createConsumer(this.target, this.listenerJmsParameters);){
            Optional<Message> matchingMessage = ((Consumer)consumerCloseableResource.getResource()).getMessage();
            if (matchingMessage.isPresent()) {
                Message message = matchingMessage.get();
                if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    this.logger.info("Jms message received: " + textMessage.getText());
                    ActionExecutionResult actionExecutionResult = ActionExecutionResult.ok(JmsListenerAction.toOutputs(textMessage));
                    return actionExecutionResult;
                }
                this.logger.error("JMS message type not handled: " + message.getClass().getSimpleName());
                return ActionExecutionResult.ko();
            }
            this.logger.error("No message available");
            return ActionExecutionResult.ko();
        }
        catch (UncheckedJmsException | IllegalArgumentException | IllegalStateException | JMSException e) {
            this.logger.error(e);
        }
        return ActionExecutionResult.ko();
    }

    private static Map<String, Object> toOutputs(TextMessage message) throws JMSException {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("textMessage", message.getText());
        outputs.put("jmsProperties", JmsListenerAction.getMessageProperties((Message)message));
        return outputs;
    }

    private static HashMap<String, Object> getMessageProperties(Message msg) throws JMSException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Enumeration srcProperties = msg.getPropertyNames();
        while (srcProperties.hasMoreElements()) {
            String propertyName = (String)srcProperties.nextElement();
            properties.put(propertyName, msg.getObjectProperty(propertyName));
        }
        return properties;
    }
}

