/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.micrometer;

import com.chutneytesting.action.micrometer.MicrometerActionHelper;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.validation.Validator;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MicrometerSummaryAction
implements Action {
    protected static final String OUTPUT_SUMMARY = "micrometerSummary";
    private final Logger logger;
    private final String name;
    private final String description;
    private final String unit;
    private final List<String> tags;
    private final String bufferLength;
    private final String expiry;
    private final String maxValue;
    private final String minValue;
    private final String percentilePrecision;
    private final Boolean publishPercentilesHistogram;
    private final String percentiles;
    private final String scale;
    private final String sla;
    private DistributionSummary distributionSummary;
    private final MeterRegistry registry;
    private final String record;

    public MicrometerSummaryAction(Logger logger, @Input(value="name") String name, @Input(value="description") String description, @Input(value="unit") String unit, @Input(value="tags") List<String> tags, @Input(value="bufferLength") String bufferLength, @Input(value="expiry") String expiry, @Input(value="maxValue") String maxValue, @Input(value="minValue") String minValue, @Input(value="percentilePrecision") String percentilePrecision, @Input(value="publishPercentilesHistogram") Boolean publishPercentilesHistogram, @Input(value="percentiles") String percentiles, @Input(value="scale") String scale, @Input(value="sla") String sla, @Input(value="distributionSummary") DistributionSummary distributionSummary, @Input(value="registry") MeterRegistry registry, @Input(value="record") String record) {
        this.logger = logger;
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.tags = tags;
        this.publishPercentilesHistogram = publishPercentilesHistogram;
        this.distributionSummary = distributionSummary;
        this.registry = Optional.ofNullable(registry).orElse((MeterRegistry)Metrics.globalRegistry);
        this.bufferLength = bufferLength;
        this.percentilePrecision = percentilePrecision;
        this.expiry = expiry;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.scale = scale;
        this.record = record;
        this.percentiles = percentiles;
        this.sla = sla;
    }

    public List<String> validateInputs() {
        Validator metricNameValidation = Validator.of(null).validate(a -> this.name != null || this.distributionSummary != null, "name and distributionSummary cannot be both null");
        return Validator.getErrorsFrom((Validator[])new Validator[]{metricNameValidation, MicrometerActionHelper.integerStringValidation(this.bufferLength, "bufferLength"), MicrometerActionHelper.integerStringValidation(this.percentilePrecision, "percentilePrecision"), MicrometerActionHelper.doubleStringValidation(this.maxValue, "maxValue"), MicrometerActionHelper.doubleStringValidation(this.minValue, "minValue"), MicrometerActionHelper.doubleStringValidation(this.scale, "scale"), MicrometerActionHelper.doubleStringValidation(this.record, "record"), MicrometerActionHelper.durationStringValidation(this.expiry, "expiry"), MicrometerActionHelper.percentilesListValidation(this.percentiles), MicrometerActionHelper.slaListToDoublesValidation(this.sla)});
    }

    public ActionExecutionResult execute() {
        try {
            this.distributionSummary = Optional.ofNullable(this.distributionSummary).orElseGet(() -> this.retrieveSummary(this.registry));
            if (this.record != null) {
                this.distributionSummary.record(MicrometerActionHelper.parseDoubleOrNull(this.record).doubleValue());
                this.logger.info("Distribution summary updated by " + this.record);
            }
            this.logger.info("Distribution summary current total is " + this.distributionSummary.totalAmount());
            this.logger.info("Distribution summary current max is " + this.distributionSummary.max());
            this.logger.info("Distribution summary current mean is " + this.distributionSummary.mean());
            this.logger.info("Distribution summary current count is " + this.distributionSummary.count());
            return ActionExecutionResult.ok(MicrometerActionHelper.toOutputs(OUTPUT_SUMMARY, this.distributionSummary));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return ActionExecutionResult.ko();
        }
    }

    private DistributionSummary retrieveSummary(MeterRegistry registry) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)Objects.requireNonNull(this.name)).description(this.description).baseUnit(this.unit).distributionStatisticBufferLength(MicrometerActionHelper.parseIntOrNull(this.bufferLength)).distributionStatisticExpiry(MicrometerActionHelper.parseDurationOrNull(this.expiry)).maximumExpectedValue(MicrometerActionHelper.parseDoubleOrNull(this.maxValue)).minimumExpectedValue(MicrometerActionHelper.parseDoubleOrNull(this.minValue)).percentilePrecision(MicrometerActionHelper.parseIntOrNull(this.percentilePrecision)).publishPercentileHistogram(this.publishPercentilesHistogram).publishPercentiles(MicrometerActionHelper.parseMapOrNull(this.percentiles, MicrometerActionHelper::parsePercentilesList)).serviceLevelObjectives(MicrometerActionHelper.parseMapOrNull(this.sla, MicrometerActionHelper::parseSlaListToDoubles));
        Optional.ofNullable(this.scale).ifPresent(t -> builder.scale(MicrometerActionHelper.parseDoubleOrNull(this.scale).doubleValue()));
        Optional.ofNullable(this.tags).ifPresent(t -> builder.tags(t.toArray(new String[0])));
        return builder.register(registry);
    }
}

