/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium;

import com.chutneytesting.action.spi.injectable.Logger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;

public interface SeleniumFindBehavior {
    default public Optional<WebElement> findElement(Logger logger, WebDriver webDriver, String selector, String by, Integer wait) {
        Optional<By> webElementBy = this.by(webDriver, selector, by);
        if (webElementBy.isPresent()) {
            try {
                FluentWait explicitWait = new FluentWait((Object)webDriver).withTimeout(Duration.of(wait != null ? (long)wait.intValue() : 1L, ChronoUnit.SECONDS)).pollingEvery(Duration.of(500L, ChronoUnit.MILLIS)).ignoring(NoSuchElementException.class, StaleElementReferenceException.class);
                WebElement elementFound = (WebElement)explicitWait.until(this.findExpectation(webElementBy.get()));
                return Optional.of(elementFound);
            }
            catch (Exception e) {
                logger.error("Cannot retrieve element : " + by + " - " + selector);
                logger.error(e.toString());
            }
        }
        return Optional.empty();
    }

    default public Optional<By> by(WebDriver webDriver, String selector, String by) {
        if (selector != null && by != null) {
            return Optional.of(WebElementFindBy.findByName(by).by(webDriver, selector));
        }
        return Optional.empty();
    }

    default public Function<WebDriver, WebElement> findExpectation(By by) {
        return ExpectedConditions.presenceOfElementLocated((By)by);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum WebElementFindBy {
        ID("id"){

            @Override
            public By by(WebDriver webDriver, String byValue) {
                return By.id((String)byValue);
            }
        }
        ,
        NAME("name"){

            @Override
            public By by(WebDriver webDriver, String byValue) {
                return By.name((String)byValue);
            }
        }
        ,
        CLASS_NAME("className"){

            @Override
            public By by(WebDriver webDriver, String byValue) {
                return By.className((String)byValue);
            }
        }
        ,
        CSS_SELECTOR("cssSelector"){

            @Override
            public By by(WebDriver webDriver, String byValue) {
                return By.cssSelector((String)byValue);
            }
        }
        ,
        XPATH("xpath"){

            @Override
            public By by(WebDriver webDriver, String byValue) {
                return By.xpath((String)byValue);
            }
        }
        ,
        ZK("zk"){

            @Override
            public By by(WebDriver webDriver, String byValue) {
                String zkId = "undefined";
                String script = String.format("return zk.Widget.$(jq('$%s'))?.uuid || 'undefined';", byValue);
                try {
                    zkId = (String)((JavascriptExecutor)webDriver).executeScript(script, new Object[0]);
                    if (zkId.equals("undefined")) {
                        TimeUnit.SECONDS.sleep(1L);
                        zkId = (String)((JavascriptExecutor)webDriver).executeScript(script, new Object[0]);
                    }
                }
                catch (InterruptedException | JavascriptException throwable) {
                    // empty catch block
                }
                return By.id((String)zkId);
            }
        };

        public final String name;

        private WebElementFindBy(String name) {
            this.name = name;
        }

        public static WebElementFindBy findByName(String name) {
            for (WebElementFindBy webElementFindBy : WebElementFindBy.values()) {
                if (!webElementFindBy.name.equals(name)) continue;
                return webElementFindBy;
            }
            throw new IllegalArgumentException("Unknown WebElementFindBy name.");
        }

        public abstract By by(WebDriver var1, String var2);
    }
}

