/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium;

import com.chutneytesting.action.selenium.SeleniumAction;
import com.chutneytesting.action.selenium.SeleniumFindBehavior;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;

public class SeleniumWaitAction
extends SeleniumAction
implements SeleniumFindBehavior {
    private final String selector;
    private final String by;
    private final Integer wait;
    private final String value;

    public SeleniumWaitAction(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait, @Input(value="value") String value) {
        super(logger, webDriver);
        this.value = value;
        this.selector = selector;
        this.by = by;
        this.wait = wait;
    }

    @Override
    public ActionExecutionResult executeSeleniumAction() {
        Optional webElement = this.by(this.webDriver, this.selector, this.by);
        if (!webElement.isPresent()) {
            this.logger.error("Cannot find condition from parameters.");
            return ActionExecutionResult.ko();
        }
        ExpectedByCondition expectedByCondition = new ExpectedByCondition(this.value);
        FluentWait explicitWait = new FluentWait((Object)this.webDriver).withTimeout(Duration.of(this.wait != null ? this.wait.longValue() : 2L, ChronoUnit.SECONDS)).pollingEvery(Duration.of(500L, ChronoUnit.MILLIS));
        explicitWait.until(expectedByCondition.toExpectedCondition((By)webElement.get()));
        return ActionExecutionResult.ok();
    }

    private class ExpectedByCondition {
        private final Pattern LOGIC_FUNCTION_PATTERN = Pattern.compile("(and|or|not)\\((.*)\\)");
        private final ExpectedByConditionEnum expectedByConditionEnum;
        private final List<ExpectedByCondition> expectedByConditions;

        ExpectedByCondition(String expectedByCondition) {
            Matcher logicFunctionMatcher = this.LOGIC_FUNCTION_PATTERN.matcher(expectedByCondition);
            if (logicFunctionMatcher.find()) {
                this.expectedByConditionEnum = ExpectedByConditionEnum.findByName(logicFunctionMatcher.group(1));
                this.expectedByConditions = ((Stream)Arrays.stream(logicFunctionMatcher.group(2).split(",")).parallel()).map(x$0 -> new ExpectedByCondition((String)x$0)).collect(Collectors.toList());
            } else {
                this.expectedByConditionEnum = ExpectedByConditionEnum.findByName(expectedByCondition);
                this.expectedByConditions = new ArrayList<ExpectedByCondition>();
            }
        }

        ExpectedCondition<?> toExpectedCondition(By by) {
            return switch (this.expectedByConditionEnum) {
                default -> throw new IncompatibleClassChangeError();
                case ExpectedByConditionEnum.ELEMENT_TO_BE_SELECTED -> ExpectedConditions.elementToBeSelected((By)by);
                case ExpectedByConditionEnum.ELEMENT_TO_BE_CLICKABLE -> ExpectedConditions.elementToBeClickable((By)by);
                case ExpectedByConditionEnum.FRAME_TO_BE_AVALAIBLE_AND_SWITCH_TO_IT -> ExpectedConditions.frameToBeAvailableAndSwitchToIt((By)by);
                case ExpectedByConditionEnum.INVISIBILITY_OF_ELEMENT_LOCATED -> ExpectedConditions.invisibilityOfElementLocated((By)by);
                case ExpectedByConditionEnum.VISIBILITY_OF_ELEMENT_LOCATED -> ExpectedConditions.visibilityOfElementLocated((By)by);
                case ExpectedByConditionEnum.VISIBILITY_OF_ALL_ELEMENT_LOCATED -> ExpectedConditions.visibilityOfAllElementsLocatedBy((By)by);
                case ExpectedByConditionEnum.PRESENCE_OF_ELEMENT_LOCATED -> ExpectedConditions.presenceOfElementLocated((By)by);
                case ExpectedByConditionEnum.PRESENCE_OF_ALL_ELEMENT_LOCATED -> ExpectedConditions.presenceOfAllElementsLocatedBy((By)by);
                case ExpectedByConditionEnum.AND -> ExpectedConditions.and((ExpectedCondition[])((ExpectedCondition[])this.expectedByConditions.parallelStream().map(expectedByCondition -> expectedByCondition.toExpectedCondition(by)).toArray()));
                case ExpectedByConditionEnum.OR -> ExpectedConditions.or((ExpectedCondition[])((ExpectedCondition[])this.expectedByConditions.parallelStream().map(expectedByCondition -> expectedByCondition.toExpectedCondition(by)).toArray()));
                case ExpectedByConditionEnum.NOT -> ExpectedConditions.not(this.expectedByConditions.get(0).toExpectedCondition(by));
            };
        }
    }

    private static enum ExpectedByConditionEnum {
        ELEMENT_TO_BE_SELECTED("elementToBeSelected"),
        ELEMENT_TO_BE_CLICKABLE("elementToBeClickable"),
        FRAME_TO_BE_AVALAIBLE_AND_SWITCH_TO_IT("frameToBeAvailableAndSwitchToIt"),
        INVISIBILITY_OF_ELEMENT_LOCATED("invisibilityOfElementLocated"),
        VISIBILITY_OF_ELEMENT_LOCATED("visibilityOfElementLocated"),
        VISIBILITY_OF_ALL_ELEMENT_LOCATED("visibilityOfAllElementLocated"),
        PRESENCE_OF_ELEMENT_LOCATED("presenceOfElementLocated"),
        PRESENCE_OF_ALL_ELEMENT_LOCATED("presenceOfAllElementLocated"),
        AND("and"),
        OR("or"),
        NOT("not");

        public final String name;

        private ExpectedByConditionEnum(String name) {
            this.name = name;
        }

        static ExpectedByConditionEnum findByName(String name) {
            for (ExpectedByConditionEnum expectedByConditionEnum : ExpectedByConditionEnum.values()) {
                if (!expectedByConditionEnum.name.equals(name)) continue;
                return expectedByConditionEnum;
            }
            throw new IllegalArgumentException("Unknown ExpectedByConditionEnum name.");
        }
    }
}

