/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution;

import com.chutneytesting.action.spi.FinallyAction;
import com.chutneytesting.action.spi.injectable.ActionsConfiguration;
import com.chutneytesting.engine.domain.execution.RxBus;
import com.chutneytesting.engine.domain.execution.command.PauseExecutionCommand;
import com.chutneytesting.engine.domain.execution.command.ResumeExecutionCommand;
import com.chutneytesting.engine.domain.execution.command.StopExecutionCommand;
import com.chutneytesting.engine.domain.execution.event.EndScenarioExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.Event;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class ScenarioExecution {
    private final List<FinallyAction> finallyActions = new ArrayList<FinallyAction>();
    private final ActionsConfiguration actionConfiguration;
    public final long executionId;
    private boolean pause = false;
    private boolean stop = false;
    private Disposable endExecutionSubscriber;

    public static ScenarioExecution createScenarioExecution(ActionsConfiguration actionConfiguration) {
        long executionId = UUID.randomUUID().getMostSignificantBits();
        return new ScenarioExecution(executionId, actionConfiguration);
    }

    private ScenarioExecution(long executionId, ActionsConfiguration actionConfiguration) {
        this.executionId = executionId;
        this.actionConfiguration = actionConfiguration;
        Disposable pauseSubscriber = RxBus.getInstance().registerOnExecutionId(PauseExecutionCommand.class, executionId, (Consumer<? super Event>)((Consumer)e -> this.pause()));
        Disposable stopSubscriber = RxBus.getInstance().registerOnExecutionId(StopExecutionCommand.class, executionId, (Consumer<? super Event>)((Consumer)e -> this.stop()));
        Disposable resumeSubscriber = RxBus.getInstance().registerOnExecutionId(ResumeExecutionCommand.class, executionId, (Consumer<? super Event>)((Consumer)e -> this.resume()));
        this.endExecutionSubscriber = RxBus.getInstance().registerOnExecutionId(EndScenarioExecutionEvent.class, executionId, (Consumer<? super Event>)((Consumer)e -> {
            pauseSubscriber.dispose();
            stopSubscriber.dispose();
            resumeSubscriber.dispose();
            this.endExecutionSubscriber.dispose();
        }));
    }

    public void registerFinallyAction(FinallyAction finallyAction) {
        this.finallyActions.add(finallyAction);
    }

    public void initFinallyActionExecution() {
        this.stop = false;
    }

    public void waitForRestart() {
        while (this.pause) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean hasToPause() {
        return this.pause;
    }

    public boolean hasToStop() {
        return this.stop;
    }

    private void pause() {
        this.pause = true;
    }

    private void stop() {
        this.stop = true;
    }

    private void resume() {
        this.pause = false;
    }

    public ActionsConfiguration getActionsConfiguration() {
        return this.actionConfiguration;
    }

    public List<FinallyAction> finallyActions() {
        return this.finallyActions;
    }
}

