/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution;

import com.chutneytesting.action.spi.injectable.StepDefinitionSpi;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.engine.domain.execution.strategies.StepStrategyDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StepDefinition
implements StepDefinitionSpi {
    public final String name;
    public final String type;
    private final Map<String, Object> inputs;
    public final List<StepDefinition> steps;
    public final Map<String, Object> outputs;
    public final Map<String, Object> validations;
    public final String environment;
    private final Target target;
    private final StepStrategyDefinition strategy;

    public StepDefinition(String name, Target target, String type, StepStrategyDefinition strategy, Map<String, Object> inputs, List<StepDefinition> steps, Map<String, Object> outputs, Map<String, Object> validations, String environment) {
        this.name = Objects.requireNonNull(name, "The argument <name> must not be null");
        this.type = Objects.requireNonNull(type, "The argument <type> must not be null");
        this.strategy = strategy;
        this.target = target;
        this.inputs = inputs != null ? Collections.unmodifiableMap(inputs) : Collections.emptyMap();
        this.steps = steps != null ? Collections.unmodifiableList(steps) : Collections.emptyList();
        this.outputs = outputs != null ? Collections.unmodifiableMap(outputs) : Collections.emptyMap();
        this.validations = validations != null ? Collections.unmodifiableMap(validations) : Collections.emptyMap();
        this.environment = environment;
    }

    public Optional<Target> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<StepStrategyDefinition> getStrategy() {
        return Optional.ofNullable(this.strategy);
    }

    public String toString() {
        return "StepDefinition{name='" + this.name + "', type='" + this.type + "', inputs=" + this.inputs + ", steps=" + this.steps + ", outputs=" + this.outputs + ", validations=" + this.validations + ", target=" + this.target + ", strategy=" + this.strategy + "}";
    }

    public Map<String, Object> inputs() {
        return this.inputs;
    }
}

