/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine.evaluation;

import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.engine.domain.environment.TargetImpl;
import com.chutneytesting.engine.domain.execution.engine.evaluation.EvaluationException;
import com.chutneytesting.engine.domain.execution.engine.evaluation.Strings;
import com.chutneytesting.engine.domain.execution.evaluation.SpelFunctions;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class StepDataEvaluator {
    private static final String EVALUATION_STRING_PREFIX = "${";
    private static final String EVALUATION_STRING_SUFFIX = "}";
    private static final String EVALUATION_STRING_ESCAPE = "\\";
    private static final Pattern EVALUATION_OBJECT_PATTERN = Pattern.compile("^(?:" + Strings.escapeForRegex("\\") + ")?" + Strings.escapeForRegex("${") + "(?:(?!" + Strings.escapeForRegex("${") + ").)*" + Strings.escapeForRegex("}") + "$", 32);
    private final SpelFunctions spelFunctions;
    private final ExpressionParser parser = new SpelExpressionParser();

    public StepDataEvaluator(SpelFunctions spelFunctions) {
        this.spelFunctions = spelFunctions;
    }

    public Map<String, Object> evaluateNamedDataWithContextVariables(Map<String, Object> data, Map<String, Object> contextVariables) throws EvaluationException {
        LinkedHashMap<String, Object> evaluatedNamedData = new LinkedHashMap<String, Object>();
        StandardEvaluationContext evaluationContext = this.buildEvaluationContext(contextVariables);
        data.forEach((dataName, dataValue) -> {
            Object value = this.evaluateObject(dataValue, (EvaluationContext)evaluationContext);
            evaluatedNamedData.put((String)dataName, value);
            evaluationContext.setVariable(dataName, value);
        });
        return evaluatedNamedData;
    }

    public String evaluate(String s, Map<String, Object> contextVariables) throws EvaluationException {
        return (String)this.evaluate((Object)s, contextVariables);
    }

    public Object evaluate(Object o, Map<String, Object> contextVariables) throws EvaluationException {
        StandardEvaluationContext evaluationContext = this.buildEvaluationContext(contextVariables);
        return this.evaluateObject(o, (EvaluationContext)evaluationContext);
    }

    public Target evaluateTarget(Target target, Map<String, Object> contextVariables) throws EvaluationException {
        TargetImpl.TargetBuilder builder = TargetImpl.builder();
        StandardEvaluationContext evaluationContext = this.buildEvaluationContext(contextVariables);
        builder.withName(target.name());
        builder.withUrl((String)this.evaluateObject(target.rawUri(), (EvaluationContext)evaluationContext));
        builder.withProperties((Map)this.evaluateObject(target.prefixedProperties(""), (EvaluationContext)evaluationContext));
        return builder.build();
    }

    private StandardEvaluationContext buildEvaluationContext(Map<String, Object> contextVariables) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.registerMethodFilter(Runtime.class, methods -> Collections.emptyList());
        evaluationContext.registerMethodFilter(ProcessBuilder.class, methods -> Collections.emptyList());
        if (this.spelFunctions != null) {
            this.spelFunctions.stream().forEach(f -> evaluationContext.registerFunction(f.getName(), f.getMethod()));
        }
        evaluationContext.setVariables(contextVariables);
        return evaluationContext;
    }

    private Object evaluateObject(Object object, EvaluationContext evaluationContext) throws EvaluationException {
        Object inputEvaluatedValue;
        if (object instanceof String) {
            String stringValue = (String)((Object)object);
            inputEvaluatedValue = this.hasOnlyOneSpel(stringValue) ? Strings.replaceExpression(stringValue, s -> this.evaluate(this.parser, evaluationContext, (String)s), EVALUATION_STRING_PREFIX, EVALUATION_STRING_SUFFIX, EVALUATION_STRING_ESCAPE) : Strings.replaceExpressions(stringValue, s -> this.evaluate(this.parser, evaluationContext, (String)s), EVALUATION_STRING_PREFIX, EVALUATION_STRING_SUFFIX, EVALUATION_STRING_ESCAPE);
        } else if (object instanceof Map) {
            Map map = object;
            LinkedHashMap evaluatedMap = new LinkedHashMap();
            map.forEach((key, value) -> {
                Object keyValue = this.evaluateObject(key, evaluationContext);
                Object valueValue = this.evaluateObject(value, evaluationContext);
                evaluatedMap.put(keyValue, valueValue);
                if (keyValue instanceof String) {
                    String stringKeyValue = (String)keyValue;
                    evaluationContext.setVariable(stringKeyValue, valueValue);
                }
            });
            inputEvaluatedValue = evaluatedMap;
        } else if (object instanceof List) {
            List list = (List)((Object)object);
            ArrayList evaluatedList = new ArrayList();
            list.forEach(obj -> evaluatedList.add(this.evaluateObject(obj, evaluationContext)));
            inputEvaluatedValue = evaluatedList;
        } else if (object instanceof Set) {
            Set set = (Set)((Object)object);
            LinkedHashSet evaluatedSet = new LinkedHashSet();
            set.forEach(obj -> evaluatedSet.add(this.evaluateObject(obj, evaluationContext)));
            inputEvaluatedValue = evaluatedSet;
        } else {
            inputEvaluatedValue = object;
        }
        return inputEvaluatedValue;
    }

    private Object evaluate(ExpressionParser parser, EvaluationContext evaluationContext, String expressionAsString) throws EvaluationException {
        Expression expression = this.parseExpression(parser, expressionAsString);
        try {
            Object result = expression.getValue(evaluationContext);
            if (result == null) {
                throw new EvaluationException("Cannot resolve " + expressionAsString + ", Spring evaluation is null");
            }
            return result;
        }
        catch (org.springframework.expression.EvaluationException e) {
            Throwable initialException = e;
            if (initialException.getCause() != null && initialException.getCause() instanceof InvocationTargetException && (initialException = (InvocationTargetException)e.getCause()).getCause() != null) {
                initialException = (Exception)initialException.getCause();
            }
            throw new EvaluationException("Cannot resolve " + expressionAsString + " , " + initialException.getMessage(), (Exception)initialException);
        }
    }

    private boolean hasOnlyOneSpel(String template) {
        return EVALUATION_OBJECT_PATTERN.matcher(template.trim()).matches();
    }

    private Expression parseExpression(ExpressionParser parser, String expressionAsString) {
        Expression expression;
        try {
            expression = parser.parseExpression(expressionAsString);
        }
        catch (ParseException e) {
            throw new EvaluationException("Cannot parse " + expressionAsString + " , " + e.getMessage(), (Exception)((Object)e));
        }
        return expression;
    }
}

