/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api;

import com.chutneytesting.environment.api.EnvironmentApi;
import com.chutneytesting.environment.api.dto.EnvironmentDto;
import com.chutneytesting.environment.api.dto.TargetDto;
import com.chutneytesting.environment.domain.TargetFilter;
import com.chutneytesting.environment.domain.exception.AlreadyExistingEnvironmentException;
import com.chutneytesting.environment.domain.exception.AlreadyExistingTargetException;
import com.chutneytesting.environment.domain.exception.CannotDeleteEnvironmentException;
import com.chutneytesting.environment.domain.exception.EnvironmentNotFoundException;
import com.chutneytesting.environment.domain.exception.InvalidEnvironmentNameException;
import com.chutneytesting.environment.domain.exception.TargetNotFoundException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin(origins={"*"})
public class HttpEnvironmentApi
implements EnvironmentApi {
    private final String ENVIRONMENT_BASE_URI = "/api/v2/environments";
    private final String TARGET_BASE_URI = "/api/v2/targets";
    private final EnvironmentApi delegate;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    HttpEnvironmentApi(EnvironmentApi delegate) {
        this.delegate = delegate;
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(path={"/api/v2/environments"}, produces={"application/json"})
    public Set<EnvironmentDto> listEnvironments() {
        return this.delegate.listEnvironments();
    }

    @Override
    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE') or hasAuthority('CAMPAIGN_WRITE') or hasAuthority('CAMPAIGN_EXECUTE') or hasAuthority('COMPONENT_WRITE')")
    @GetMapping(path={"/api/v2/environments/names"}, produces={"application/json"})
    public Set<String> listEnvironmentsNames() {
        return this.delegate.listEnvironmentsNames();
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PostMapping(value={"/api/v2/environments"}, consumes={"application/json"})
    public EnvironmentDto createEnvironment(@RequestBody EnvironmentDto environmentDto) throws InvalidEnvironmentNameException, AlreadyExistingEnvironmentException {
        return this.delegate.createEnvironment(environmentDto, false);
    }

    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PostMapping(value={"/api/v2/environments"}, consumes={"multipart/form-data"})
    public EnvironmentDto importEnvironment(@RequestParam(value="file") MultipartFile file) {
        try {
            return this.importEnvironment((EnvironmentDto)this.objectMapper.readValue(file.getBytes(), EnvironmentDto.class));
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot deserialize file: " + file.getName(), e);
        }
    }

    @Override
    public EnvironmentDto importEnvironment(EnvironmentDto environmentDto) {
        return this.delegate.importEnvironment(environmentDto);
    }

    @Override
    public EnvironmentDto createEnvironment(@RequestBody EnvironmentDto environmentDto, boolean force) {
        throw new UnsupportedOperationException();
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @DeleteMapping(value={"/api/v2/environments/{environmentName}"})
    public void deleteEnvironment(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException, CannotDeleteEnvironmentException {
        this.delegate.deleteEnvironment(environmentName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PutMapping(value={"/api/v2/environments/{environmentName}"})
    public void updateEnvironment(@PathVariable(value="environmentName") String environmentName, @RequestBody EnvironmentDto environmentDto) throws InvalidEnvironmentNameException, EnvironmentNotFoundException {
        this.delegate.updateEnvironment(environmentName, environmentDto);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(value={"/api/v2/environments/{environmentName}"})
    public EnvironmentDto getEnvironment(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException {
        return this.delegate.getEnvironment(environmentName);
    }

    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PostMapping(value={"/api/v2/environments/{environmentName}/targets"}, consumes={"multipart/form-data"})
    public TargetDto importTarget(@PathVariable(value="environmentName") String environmentName, @RequestParam(value="file") MultipartFile file) {
        try {
            return this.importTarget(environmentName, (TargetDto)this.objectMapper.readValue(file.getBytes(), TargetDto.class));
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot deserialize file: " + file.getName(), e);
        }
    }

    @Override
    public TargetDto importTarget(String environmentName, TargetDto targetDto) {
        return this.delegate.importTarget(environmentName, targetDto);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(path={"/api/v2/targets/names"}, produces={"application/json"})
    public Set<String> listTargetsNames() throws EnvironmentNotFoundException {
        return this.delegate.listTargetsNames();
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(path={"/api/v2/targets"}, produces={"application/json"})
    public List<TargetDto> listTargets(TargetFilter filter) throws EnvironmentNotFoundException {
        return this.delegate.listTargets(filter);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(value={"/api/v2/environments/{environmentName}/targets/{targetName}"})
    public TargetDto getTarget(@PathVariable(value="environmentName") String environmentName, @PathVariable(value="targetName") String targetName) throws EnvironmentNotFoundException, TargetNotFoundException {
        return this.delegate.getTarget(environmentName, targetName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @DeleteMapping(value={"/api/v2/environments/{environmentName}/targets/{targetName}"})
    public void deleteTarget(@PathVariable(value="environmentName") String environmentName, @PathVariable(value="targetName") String targetName) throws EnvironmentNotFoundException, TargetNotFoundException {
        this.delegate.deleteTarget(environmentName, targetName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @DeleteMapping(value={"/api/v2/targets/{targetName}"})
    public void deleteTarget(@PathVariable(value="targetName") String targetName) throws EnvironmentNotFoundException, TargetNotFoundException {
        this.delegate.deleteTarget(targetName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PostMapping(value={"/api/v2/targets"})
    public void addTarget(@RequestBody TargetDto targetDto) throws EnvironmentNotFoundException, AlreadyExistingTargetException {
        this.delegate.addTarget(targetDto);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PutMapping(value={"/api/v2/targets/{targetName}"})
    public void updateTarget(@PathVariable(value="targetName") String targetName, @RequestBody TargetDto targetDto) throws EnvironmentNotFoundException, TargetNotFoundException {
        this.delegate.updateTarget(targetName, targetDto);
    }
}

