/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.infra;

import com.chutneytesting.environment.domain.Environment;
import com.chutneytesting.environment.infra.JsonTarget;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonEnvironment {
    public String name;
    public String description;
    public Set<JsonTarget> targets;

    public JsonEnvironment() {
    }

    private JsonEnvironment(String name, String description, Set<JsonTarget> targets) {
        this.name = name;
        this.description = description;
        this.targets = targets;
    }

    public static JsonEnvironment from(Environment environment) {
        Set<JsonTarget> targets = environment.targets.stream().map(JsonTarget::from).collect(Collectors.toSet());
        return new JsonEnvironment(environment.name, environment.description, targets);
    }

    public Environment toEnvironment() {
        return Environment.builder().withName(this.name).withDescription(this.description).withTargets(Optional.ofNullable(this.targets).orElse(Collections.emptySet()).stream().map(t -> t.toTarget(this.name)).collect(Collectors.toSet())).build();
    }
}

