/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.implcore.trace;

import com.clickhouse.client.internal.opencensus.common.Clock;
import com.clickhouse.client.internal.opencensus.implcore.internal.EventQueue;
import com.clickhouse.client.internal.opencensus.implcore.internal.SimpleEventQueue;
import com.clickhouse.client.internal.opencensus.implcore.trace.StartEndHandlerImpl;
import com.clickhouse.client.internal.opencensus.implcore.trace.TracerImpl;
import com.clickhouse.client.internal.opencensus.implcore.trace.config.TraceConfigImpl;
import com.clickhouse.client.internal.opencensus.implcore.trace.export.ExportComponentImpl;
import com.clickhouse.client.internal.opencensus.implcore.trace.internal.RandomHandler;
import com.clickhouse.client.internal.opencensus.implcore.trace.propagation.PropagationComponentImpl;
import com.clickhouse.client.internal.opencensus.trace.Tracer;
import com.clickhouse.client.internal.opencensus.trace.config.TraceConfig;
import com.clickhouse.client.internal.opencensus.trace.export.ExportComponent;
import com.clickhouse.client.internal.opencensus.trace.propagation.PropagationComponent;

public final class TraceComponentImplBase {
    private final ExportComponentImpl exportComponent;
    private final PropagationComponent propagationComponent = new PropagationComponentImpl();
    private final Clock clock;
    private final TraceConfig traceConfig = new TraceConfigImpl();
    private final Tracer tracer;

    public TraceComponentImplBase(Clock clock, RandomHandler randomHandler, EventQueue eventQueue) {
        this.clock = clock;
        this.exportComponent = eventQueue instanceof SimpleEventQueue ? ExportComponentImpl.createWithoutInProcessStores(eventQueue) : ExportComponentImpl.createWithInProcessStores(eventQueue);
        StartEndHandlerImpl startEndHandler = new StartEndHandlerImpl(this.exportComponent.getSpanExporter(), this.exportComponent.getRunningSpanStore(), this.exportComponent.getSampledSpanStore(), eventQueue);
        this.tracer = new TracerImpl(randomHandler, startEndHandler, clock, this.traceConfig);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public PropagationComponent getPropagationComponent() {
        return this.propagationComponent;
    }

    public final Clock getClock() {
        return this.clock;
    }

    public ExportComponent getExportComponent() {
        return this.exportComponent;
    }

    public TraceConfig getTraceConfig() {
        return this.traceConfig;
    }
}

