/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.stream.AbstractByteArrayInputStream;
import java.util.Iterator;

public class IterableByteArrayInputStream
extends AbstractByteArrayInputStream {
    private final Iterator<byte[]> it;

    public IterableByteArrayInputStream(Iterable<byte[]> source, Runnable postCloseAction) {
        super(postCloseAction);
        this.it = ClickHouseChecker.nonNull(source, "Source").iterator();
    }

    @Override
    protected int updateBuffer() {
        this.position = 0;
        while (this.it.hasNext()) {
            byte[] bytes = this.it.next();
            int len = bytes != null ? bytes.length : 0;
            if (len <= 0) continue;
            this.buffer = bytes;
            this.limit = len;
            return this.limit;
        }
        this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
        this.limit = 0;
        return 0;
    }
}

