/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.stream.AbstractByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class WrappedInputStream
extends AbstractByteArrayInputStream {
    private final InputStream in;

    @Override
    protected int updateBuffer() throws IOException {
        int read;
        this.position = 0;
        if (this.closed) {
            this.limit = 0;
            return 0;
        }
        int off = 0;
        for (int len = this.buffer.length; len > 0 && (read = this.in.read(this.buffer, off, len)) != -1; len -= read) {
            off += read;
        }
        this.limit = off;
        return this.limit - this.position;
    }

    public WrappedInputStream(InputStream input, int bufferSize, Runnable postCloseAction) {
        super(postCloseAction);
        this.in = ClickHouseChecker.nonNull(input, "InputStream");
        this.buffer = new byte[ClickHouseUtils.getBufferSize(bufferSize, (Integer)ClickHouseClientOption.READ_BUFFER_SIZE.getDefaultValue(), (Integer)ClickHouseClientOption.MAX_BUFFER_SIZE.getDefaultValue())];
        this.position = 0;
        this.limit = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.in.close();
        }
        finally {
            super.close();
        }
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        if (reader == null) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int offset = this.position;
        int length = 0;
        boolean more = true;
        while (more) {
            int remain = this.limit - this.position;
            if (remain < 1) {
                this.closeQuietly();
                more = false;
                continue;
            }
            int read = reader.update(this.buffer, this.position, this.limit);
            if (read == -1) {
                byte[] bytes = new byte[this.limit];
                System.arraycopy(this.buffer, this.position, bytes, this.position, remain);
                length += remain;
                this.position = this.limit;
                list.add(bytes);
                if (this.updateBuffer() >= 1) continue;
                this.closeQuietly();
                more = false;
                continue;
            }
            length += read;
            this.position += read;
            list.add(this.buffer);
            more = false;
        }
        return this.byteBuffer.update(list, offset, length);
    }

    @Override
    public long pipe(ClickHouseOutputStream output) throws IOException {
        long count = 0L;
        if (output == null || output.isClosed()) {
            return count;
        }
        this.ensureOpen();
        int remain = this.limit - this.position;
        if (remain > 0) {
            output.write(this.buffer, this.position, remain);
            count += (long)remain;
            this.position = this.limit;
        }
        while ((remain = this.in.read(this.buffer)) != -1) {
            output.write(this.buffer, 0, remain);
            count += (long)remain;
        }
        this.close();
        return count;
    }
}

