/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal.apache.http.protocol;

import com.clickhouse.jdbc.internal.apache.http.HttpException;
import com.clickhouse.jdbc.internal.apache.http.HttpResponse;
import com.clickhouse.jdbc.internal.apache.http.HttpResponseInterceptor;
import com.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import com.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import com.clickhouse.jdbc.internal.apache.http.protocol.HttpContext;
import com.clickhouse.jdbc.internal.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

