/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import com.clickhouse.jdbc.internal.apache.http.client.CookieStore;
import com.clickhouse.jdbc.internal.apache.http.impl.client.BasicCookieStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.Utils;

public class ClickHouseCookieStoreProvider {
    private static final Map<String, CookieStore> cookieStoreMap = new ConcurrentHashMap<String, CookieStore>();

    public CookieStore getCookieStore(ClickHouseProperties properties) {
        return this.hasValidProperties(properties) && properties.isUseSharedCookieStore() ? cookieStoreMap.computeIfAbsent(this.getCookieStoreKey(properties), k -> new BasicCookieStore()) : null;
    }

    private boolean hasValidProperties(ClickHouseProperties properties) {
        return properties != null && !Utils.isNullOrEmptyString(properties.getHost()) && properties.getPort() > 0 && !Utils.isNullOrEmptyString(properties.getDatabase());
    }

    private String getCookieStoreKey(ClickHouseProperties properties) {
        return String.format("%s:%s/%s", properties.getHost(), properties.getPort(), properties.getDatabase());
    }
}

