/*
 * Decompiled with CFR 0.152.
 */
package com.clickntap.vimeo;

import com.clickntap.vimeo.VimeoException;
import com.clickntap.vimeo.VimeoResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class Vimeo {
    private static final String VIMEO_SERVER = "https://api.vimeo.com";
    private String token;
    private String tokenType;
    private URL proxy;

    public Vimeo(String token) {
        this(token, "bearer");
    }

    public Vimeo(String token, String tokenType) {
        this.token = token;
        this.tokenType = tokenType;
    }

    public VimeoResponse getVideoInfo(String endpoint) throws IOException {
        return this.apiRequest(endpoint, "GET", null, null);
    }

    public VimeoResponse get(String endpoint) throws IOException {
        return this.apiRequest(endpoint, "GET", null, null);
    }

    public VimeoResponse get(String endpoint, Map<String, String> params) throws IOException {
        return this.apiRequest(endpoint, "GET", params, null);
    }

    public VimeoResponse post(String endpoint) throws IOException {
        return this.apiRequest(endpoint, "POST", null, null);
    }

    public VimeoResponse post(String endpoint, Map<String, String> params) throws IOException {
        return this.apiRequest(endpoint, "POST", params, null);
    }

    public VimeoResponse put(String endpoint) throws IOException {
        return this.apiRequest(endpoint, "PUT", null, null);
    }

    public VimeoResponse put(String endpoint, Map<String, String> params) throws IOException {
        return this.apiRequest(endpoint, "PUT", params, null);
    }

    public VimeoResponse delete(String endpoint) throws IOException {
        return this.apiRequest(endpoint, "DELETE", null, null);
    }

    public VimeoResponse delete(String endpoint, Map<String, String> params) throws IOException {
        return this.apiRequest(endpoint, "DELETE", params, null);
    }

    public VimeoResponse patch(String endpoint) throws IOException {
        return this.apiRequest(endpoint, "PATCH", null, null);
    }

    public VimeoResponse patch(String endpoint, Map<String, String> params) throws IOException {
        return this.apiRequest(endpoint, "PATCH", params, null);
    }

    public VimeoResponse updateVideoMetadata(String videoEndpoint, String name, String description, String license, String privacyView, String privacyEmbed, boolean reviewLink) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        params.put("description", description);
        params.put("license", license);
        params.put("privacy.view", privacyView);
        params.put("privacy.embed", privacyEmbed);
        params.put("review_link", reviewLink ? "true" : "false");
        return this.apiRequest(videoEndpoint, "PATCH", params, null);
    }

    public VimeoResponse addVideoPrivacyDomain(String videoEndpoint, String domain) throws ClientProtocolException, UnsupportedEncodingException, IOException {
        return this.apiRequest(new StringBuffer(videoEndpoint).append("/privacy/domains/").append(URLEncoder.encode(domain, "UTF-8")).toString(), "PUT", null, null);
    }

    public VimeoResponse getVideoPrivacyDomains(String videoEndpoint) throws IOException {
        return this.apiRequest(new StringBuffer(videoEndpoint).append("/privacy/domains").toString(), "GET", null, null);
    }

    public VimeoResponse removeVideo(String videoEndpoint) throws IOException {
        return this.apiRequest(videoEndpoint, "DELETE", null, null);
    }

    public VimeoResponse setVideoThumb(String videoEndpoint, float time, boolean active) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("time", Float.toString(time));
        params.put("active", Boolean.toString(active));
        return this.post(new StringBuffer(videoEndpoint).append("/pictures").toString(), params);
    }

    public VimeoResponse getMe() throws IOException {
        return this.apiRequest("/me", "GET", null, null);
    }

    public VimeoResponse getVideos() throws IOException {
        return this.apiRequest("/videos", "GET", null, null);
    }

    public VimeoResponse searchVideos(String query) throws IOException {
        return this.apiRequest("/videos?query=" + query, "GET", null, null);
    }

    public VimeoResponse searchVideos(String query, String pageNumber, String itemsPerPage) throws IOException {
        String apiRequestEndpoint = "/me/videos?page=" + pageNumber + "&per_page=" + itemsPerPage + "&query=" + query;
        return this.apiRequest(apiRequestEndpoint, "GET", null, null);
    }

    public VimeoResponse beginUploadVideo(Map<String, String> params) throws IOException {
        return this.apiRequest("/me/videos", "POST", params, null);
    }

    public VimeoResponse uploadVideo(File file, String uploadLinkSecure) throws IOException {
        return this.uploadVideo(new FileInputStream(file), uploadLinkSecure);
    }

    public VimeoResponse uploadVideo(byte[] bytes, String uploadLinkSecure) throws IOException {
        return this.uploadVideo(new ByteArrayInputStream(bytes), uploadLinkSecure);
    }

    public VimeoResponse uploadVideo(InputStream inputStream, String uploadLinkSecure) throws IOException {
        return this.apiRequest(uploadLinkSecure, "PUT", null, inputStream);
    }

    public VimeoResponse endUploadVideo(String completeUri) throws IOException {
        return this.apiRequest(completeUri, "DELETE", null, null);
    }

    public String addVideo(File file, boolean upgradeTo1080) throws IOException, VimeoException {
        return this.addVideo(new FileInputStream(file), upgradeTo1080);
    }

    public String addVideo(byte[] bytes, boolean upgradeTo1080) throws IOException, VimeoException {
        return this.addVideo(new ByteArrayInputStream(bytes), upgradeTo1080);
    }

    public String addVideo(InputStream inputStream, boolean upgradeTo1080) throws IOException, VimeoException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "streaming");
        params.put("redirect_url", "");
        params.put("upgrade_to_1080", upgradeTo1080 ? "true" : "false");
        VimeoResponse response = this.beginUploadVideo(params);
        if (response.getStatusCode() == 201) {
            this.uploadVideo(inputStream, response.getJson().getString("upload_link_secure"));
            response = this.endUploadVideo(response.getJson().getString("complete_uri"));
            if (response.getStatusCode() == 201) {
                return response.getJson().getString("Location");
            }
        }
        throw new VimeoException(new StringBuffer("HTTP Status Code: ").append(response.getStatusCode()).toString());
    }

    public VimeoResponse likesVideo(String videoId) throws IOException {
        return this.apiRequest(new StringBuffer("/me/likes/").append(videoId).toString(), "GET", null, null);
    }

    public VimeoResponse likeVideo(String videoId) throws IOException {
        return this.apiRequest(new StringBuffer("/me/likes/").append(videoId).toString(), "PUT", null, null);
    }

    public VimeoResponse unlikeVideo(String videoId) throws IOException {
        return this.apiRequest(new StringBuffer("/me/likes/").append(videoId).toString(), "DELETE", null, null);
    }

    public VimeoResponse checkEmbedPreset(String videoEndPoint, String presetId) throws IOException {
        return this.apiRequest(new StringBuffer(videoEndPoint).append("/presets/").append(presetId).toString(), "GET", null, null);
    }

    public VimeoResponse addEmbedPreset(String videoEndPoint, String presetId) throws IOException {
        return this.apiRequest(new StringBuffer(videoEndPoint).append("/presets/").append(presetId).toString(), "PUT", null, null);
    }

    public VimeoResponse removeEmbedPreset(String videoEndPoint, String presetId) throws IOException {
        return this.apiRequest(new StringBuffer(videoEndPoint).append("/presets/").append(presetId).toString(), "DELETE", null, null);
    }

    public VimeoResponse getTextTracks(String videoEndPoint) throws IOException {
        return this.apiRequest(new StringBuffer(videoEndPoint).append("/texttracks").toString(), "GET", null, null);
    }

    public VimeoResponse getTextTrack(String videoEndPoint, String textTrackId) throws IOException {
        return this.apiRequest(new StringBuffer(videoEndPoint).append("/texttracks/").append(textTrackId).toString(), "GET", null, null);
    }

    public String addTextTrack(String videoEndPoint, File file, boolean active, String type, String language, String name) throws IOException, VimeoException {
        return this.addTextTrack(videoEndPoint, new FileInputStream(file), active, type, language, name);
    }

    public String addTextTrack(String videoEndPoint, byte[] bytes, boolean active, String type, String language, String name) throws IOException, VimeoException {
        return this.addTextTrack(videoEndPoint, new ByteArrayInputStream(bytes), active, type, language, name);
    }

    public String addTextTrack(String videoEndPoint, InputStream inputStream, boolean active, String type, String language, String name) throws IOException, VimeoException {
        String textTrackUploadLink;
        VimeoResponse response = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("active", active ? "true" : "false");
        params.put("type", type);
        params.put("language", language);
        params.put("name", name);
        VimeoResponse addVideoRespose = this.apiRequest(new StringBuffer(videoEndPoint).append("/texttracks").toString(), "POST", params, null);
        if (addVideoRespose.getStatusCode() == 201 && (response = this.apiRequest(textTrackUploadLink = addVideoRespose.getJson().getString("link"), "PUT", null, inputStream)).getStatusCode() == 200) {
            return addVideoRespose.getJson().getString("uri");
        }
        throw new VimeoException(new StringBuffer("HTTP Status Code: ").append(response.getStatusCode()).toString());
    }

    public VimeoResponse updateTextTrack(String videoEndPoint, String textTrackUri, boolean active, String type, String language, String name) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("active", active ? "true" : "false");
        params.put("type", type);
        params.put("language", language);
        params.put("name", name);
        return this.apiRequest(new StringBuffer(videoEndPoint).append(textTrackUri).toString(), "PATCH", params, null);
    }

    public VimeoResponse removeTextTrack(String videoEndPoint, String textTrackId) throws IOException {
        return this.apiRequest(new StringBuffer(videoEndPoint).append("/texttracks/").append(textTrackId).toString(), "DELETE", null, null);
    }

    public URL getProxy() {
        return this.proxy;
    }

    public void setProxy(URL proxy) {
        this.proxy = proxy;
    }

    protected VimeoResponse apiRequest(String endpoint, String methodName, Map<String, String> params, InputStream inputStream) throws IOException {
        Object out;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = null;
        String url = null;
        url = endpoint.startsWith("http") ? endpoint : new StringBuffer(VIMEO_SERVER).append(endpoint).toString();
        if (methodName.equals("GET")) {
            request = new HttpGet(url);
        } else if (methodName.equals("POST")) {
            request = new HttpPost(url);
        } else if (methodName.equals("PUT")) {
            request = new HttpPut(url);
        } else if (methodName.equals("DELETE")) {
            request = new HttpDelete(url);
        } else if (methodName.equals("PATCH")) {
            request = new HttpPatch(url);
        }
        request.addHeader("Accept", "application/vnd.vimeo.*+json;version=3.2");
        request.addHeader("Authorization", new StringBuffer(this.tokenType).append(' ').append(this.token).toString());
        InputStreamEntity entity = null;
        if (params != null) {
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            for (String key : params.keySet()) {
                postParameters.add(new BasicNameValuePair(key, params.get(key)));
            }
            entity = new UrlEncodedFormEntity(postParameters);
        } else if (inputStream != null) {
            entity = new InputStreamEntity(inputStream, ContentType.MULTIPART_FORM_DATA);
        }
        if (entity != null) {
            if (request instanceof HttpPost) {
                ((HttpPost)request).setEntity((HttpEntity)entity);
            } else if (request instanceof HttpPatch) {
                ((HttpPatch)request).setEntity((HttpEntity)entity);
            } else if (request instanceof HttpPut) {
                ((HttpPut)request).setEntity((HttpEntity)entity);
            }
        }
        if (this.proxy != null) {
            HttpHost httpProxy = new HttpHost(this.proxy.getHost(), this.proxy.getPort(), this.proxy.getProtocol());
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            request.setConfig(config);
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        String responseAsString = null;
        int statusCode = response.getStatusLine().getStatusCode();
        if (methodName.equals("PUT") || methodName.equals("DELETE")) {
            out = new JSONObject();
            for (Header header : response.getAllHeaders()) {
                out.put(header.getName(), (Object)header.getValue());
            }
            responseAsString = out.toString();
        } else if (statusCode != 204) {
            out = new ByteArrayOutputStream();
            response.getEntity().writeTo((OutputStream)out);
            responseAsString = ((ByteArrayOutputStream)out).toString("UTF-8");
            ((ByteArrayOutputStream)out).close();
        }
        JSONObject json = null;
        JSONObject headers = null;
        try {
            json = new JSONObject(responseAsString);
            headers = new JSONObject();
            for (Header header : response.getAllHeaders()) {
                headers.put(header.getName(), (Object)header.getValue());
            }
        }
        catch (Exception e) {
            json = new JSONObject();
            headers = new JSONObject();
        }
        VimeoResponse vimeoResponse = new VimeoResponse(json, headers, statusCode);
        response.close();
        client.close();
        return vimeoResponse;
    }
}

