/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api;

import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.Database;
import com.cloudant.client.api.model.ChangesResult;
import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.org.lightcouch.CouchDbClient;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;

public class Changes {
    private final CouchDbClient client;
    private final Gson gson;
    private final DatabaseURIHelper databaseHelper;
    private BufferedReader reader;
    private ChangesResult.Row nextRow;
    private boolean stop;

    Changes(CloudantClient client, Database database) {
        this.client = client.couchDbClient;
        this.gson = database.getGson();
        this.databaseHelper = new DatabaseURIHelper(database.getDBUri());
    }

    public Changes continuousChanges() {
        URI uri = this.databaseHelper.changesUri("feed", "continuous");
        InputStream in = this.client.get(uri);
        try {
            InputStreamReader is = new InputStreamReader(in, "UTF-8");
            this.setReader(new BufferedReader(is));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public boolean hasNext() {
        return this.readNextRow();
    }

    public ChangesResult.Row next() {
        return this.getNextRow();
    }

    public void stop() {
        this.stop = true;
    }

    public ChangesResult getChanges() {
        URI uri = this.databaseHelper.changesUri("feed", "normal");
        return this.client.get(uri, ChangesResult.class);
    }

    public Changes since(String since) {
        this.databaseHelper.query("since", since);
        return this;
    }

    public Changes limit(int limit) {
        this.databaseHelper.query("limit", limit);
        return this;
    }

    public Changes heartBeat(long heartBeat) {
        this.databaseHelper.query("heartbeat", heartBeat);
        return this;
    }

    public Changes timeout(long timeout) {
        this.databaseHelper.query("timeout", timeout);
        return this;
    }

    public Changes filter(String filter) {
        this.databaseHelper.query("filter", filter);
        return this;
    }

    public Changes includeDocs(boolean includeDocs) {
        this.databaseHelper.query("include_docs", includeDocs);
        return this;
    }

    public Changes style(String style) {
        this.databaseHelper.query("style", style);
        return this;
    }

    public Changes descending(boolean descending) {
        this.databaseHelper.query("descending", descending);
        return this;
    }

    public Changes parameter(String name, String value) {
        this.databaseHelper.query(name, value);
        return this;
    }

    private boolean readNextRow() {
        boolean hasNext = false;
        try {
            if (!this.stop) {
                String row;
                while ((row = this.getReader().readLine()) != null && row.isEmpty() || row == null || row.startsWith("{\"last_seq\":")) {
                }
                this.setNextRow((ChangesResult.Row)this.gson.fromJson(row, ChangesResult.Row.class));
                hasNext = true;
            }
        }
        catch (Exception e) {
            this.terminate();
            throw new CouchDbException("Error reading continuous stream.", e);
        }
        if (!hasNext) {
            this.terminate();
        }
        return hasNext;
    }

    private BufferedReader getReader() {
        return this.reader;
    }

    private void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    private ChangesResult.Row getNextRow() {
        return this.nextRow;
    }

    private void setNextRow(ChangesResult.Row nextRow) {
        this.nextRow = nextRow;
    }

    private void terminate() {
        CouchDbUtil.close(this.getReader());
    }
}

