/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api;

import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.views.Key;
import com.cloudant.client.internal.util.CloudFoundryServices;
import com.cloudant.client.internal.util.DeserializationTypes;
import com.cloudant.client.internal.util.IndexDeserializer;
import com.cloudant.client.internal.util.SecurityDeserializer;
import com.cloudant.client.internal.util.ShardDeserializer;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.client.org.lightcouch.CouchDbProperties;
import com.cloudant.http.HttpConnectionInterceptor;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import com.cloudant.http.internal.interceptors.CookieInterceptor;
import com.cloudant.http.internal.interceptors.ProxyAuthInterceptor;
import com.cloudant.http.internal.interceptors.SSLCustomizerInterceptor;
import com.cloudant.http.internal.interceptors.TimeoutCustomizationInterceptor;
import com.cloudant.http.internal.interceptors.UserAgentInterceptor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;

public class ClientBuilder {
    private static final UserAgentInterceptor USER_AGENT_INTERCEPTOR = new UserAgentInterceptor(ClientBuilder.class.getClassLoader(), "META-INF/com.cloudant.client.properties");
    public static final int DEFAULT_MAX_CONNECTIONS = 6;
    public static final long DEFAULT_CONNECTION_TIMEOUT = 5L;
    public static final long DEFAULT_READ_TIMEOUT = 5L;
    private static final Logger logger = Logger.getLogger(ClientBuilder.class.getName());
    private List<HttpConnectionRequestInterceptor> requestInterceptors = new ArrayList<HttpConnectionRequestInterceptor>();
    private List<HttpConnectionResponseInterceptor> responseInterceptors = new ArrayList<HttpConnectionResponseInterceptor>();
    private String password;
    private String username;
    private URL url;
    private GsonBuilder gsonBuilder;
    private int maxConnections = 6;
    private URL proxyURL;
    private String proxyUser;
    private String proxyPassword;
    private boolean isSSLAuthenticationDisabled;
    private SSLSocketFactory authenticatedModeSSLSocketFactory;
    private long connectTimeout = 5L;
    private TimeUnit connectTimeoutUnit = TimeUnit.MINUTES;
    private long readTimeout = 5L;
    private TimeUnit readTimeoutUnit = TimeUnit.MINUTES;

    public static ClientBuilder account(String account) {
        logger.config("Account: " + account);
        try {
            URL url = new URL(String.format("https://%s.cloudant.com", account));
            return ClientBuilder.url(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not generate url from account name.", e);
        }
    }

    public static ClientBuilder url(URL url) {
        return new ClientBuilder(url);
    }

    private ClientBuilder(URL url) {
        String urlPath;
        logger.config("URL: " + url);
        String urlProtocol = url.getProtocol();
        String urlHost = url.getHost();
        int urlPort = url.getPort();
        if (urlPort < 0) {
            urlPort = url.getDefaultPort();
        }
        if (url.getUserInfo() != null) {
            try {
                this.username = URLDecoder.decode(url.getUserInfo().substring(0, url.getUserInfo().indexOf(":")), "UTF-8");
                this.password = URLDecoder.decode(url.getUserInfo().substring(url.getUserInfo().indexOf(":") + 1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        urlPath = (urlPath = url.getPath().trim()).endsWith("/") ? urlPath.substring(0, urlPath.length() - 1) : urlPath;
        try {
            this.url = new URL(urlProtocol + "://" + urlHost + ":" + urlPort + urlPath);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public CloudantClient build() {
        logger.config("Building client using URL: " + this.url);
        CouchDbProperties props = new CouchDbProperties(this.url);
        props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{USER_AGENT_INTERCEPTOR});
        if (this.username != null && this.password != null) {
            CookieInterceptor cookieInterceptor = new CookieInterceptor(this.username, this.password, this.url.toString());
            props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{cookieInterceptor});
            props.addResponseInterceptors((HttpConnectionResponseInterceptor)cookieInterceptor);
            logger.config("Added cookie interceptor");
        } else if (this.username != null || this.password != null) {
            throw new CouchDbException("Either a username and password must be provided, or both values must be null. Please check the credentials and try again.");
        }
        logger.config(String.format("Connect timeout: %s %s", new Object[]{this.connectTimeout, this.connectTimeoutUnit}));
        logger.config(String.format("Read timeout: %s %s", new Object[]{this.readTimeout, this.readTimeoutUnit}));
        try {
            boolean shouldLogValueWarning = false;
            boolean isUsingDefaultTTLValue = true;
            String ttlString = Security.getProperty("networkaddress.cache.ttl");
            if (ttlString != null) {
                try {
                    int ttl = Integer.parseInt(ttlString);
                    isUsingDefaultTTLValue = false;
                    logger.finest("networkaddress.cache.ttl was " + ttl);
                    if (ttl > 30 || ttl < 0) {
                        shouldLogValueWarning = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.finest("networkaddress.cache.ttl was not an int.");
                }
            }
            if (isUsingDefaultTTLValue && System.getSecurityManager() != null) {
                shouldLogValueWarning = true;
            }
            if (shouldLogValueWarning) {
                logger.warning("DNS cache lifetime may be too long. DNS cache lifetimes in excess of 30 seconds may impede client operation during cluster failover.");
            }
        }
        catch (SecurityException e) {
            logger.warning("Permission denied to check Java DNS cache TTL. If the cache lifetime is too long cluster failover will be impeded.");
        }
        props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{new TimeoutCustomizationInterceptor(this.connectTimeout, this.connectTimeoutUnit, this.readTimeout, this.readTimeoutUnit)});
        props.setMaxConnections(this.maxConnections);
        props.setProxyURL(this.proxyURL);
        if (this.proxyUser != null) {
            if ("http".equals(this.url.getProtocol())) {
                props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{new ProxyAuthInterceptor(this.proxyUser, this.proxyPassword)});
                logger.config("Added proxy auth interceptor");
            } else {
                props.setProxyAuthentication(new PasswordAuthentication(this.proxyUser, this.proxyPassword.toCharArray()));
            }
        }
        if (this.isSSLAuthenticationDisabled) {
            props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{SSLCustomizerInterceptor.SSL_AUTH_DISABLED_INTERCEPTOR});
            logger.config("SSL authentication is disabled");
        }
        if (this.authenticatedModeSSLSocketFactory != null) {
            props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{new SSLCustomizerInterceptor(this.authenticatedModeSSLSocketFactory)});
            logger.config("Added custom SSL socket factory");
        }
        if (this.requestInterceptors != null) {
            for (HttpConnectionRequestInterceptor requestInterceptor : this.requestInterceptors) {
                props.addRequestInterceptors(requestInterceptor);
                logger.config("Added request interceptor: " + requestInterceptor.getClass().getName());
            }
        }
        if (this.responseInterceptors != null) {
            for (HttpConnectionResponseInterceptor responseInterceptor : this.responseInterceptors) {
                props.addResponseInterceptors(responseInterceptor);
                logger.config("Added response interceptor: " + responseInterceptor.getClass().getName());
            }
        }
        if (this.gsonBuilder == null) {
            this.gsonBuilder = new GsonBuilder();
            logger.config("Using default GSON builder");
        } else {
            logger.config("Using custom GSON builder");
        }
        this.gsonBuilder.registerTypeAdapter(DeserializationTypes.SHARDS, (Object)new ShardDeserializer()).registerTypeAdapter(DeserializationTypes.INDICES, (Object)new IndexDeserializer()).registerTypeAdapter(DeserializationTypes.PERMISSIONS_MAP, (Object)new SecurityDeserializer()).registerTypeAdapter(Key.ComplexKey.class, (Object)new Key.ComplexKeyDeserializer());
        return new CloudantClient(props, this.gsonBuilder);
    }

    public ClientBuilder username(String username) {
        this.username = username;
        return this;
    }

    public ClientBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ClientBuilder gsonBuilder(GsonBuilder gsonBuilder) {
        this.gsonBuilder = gsonBuilder;
        return this;
    }

    public ClientBuilder maxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public ClientBuilder proxyURL(URL proxyURL) {
        this.proxyURL = proxyURL;
        return this;
    }

    public ClientBuilder proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public ClientBuilder proxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public ClientBuilder disableSSLAuthentication() {
        if (this.authenticatedModeSSLSocketFactory != null) {
            throw new IllegalStateException("Cannot disable SSL authentication when a custom SSLSocketFactory has been set.");
        }
        this.isSSLAuthenticationDisabled = true;
        return this;
    }

    public ClientBuilder customSSLSocketFactory(SSLSocketFactory factory) {
        if (this.isSSLAuthenticationDisabled) {
            throw new IllegalStateException("Cannot use a custom SSLSocketFactory when SSL authentication is disabled.");
        }
        this.authenticatedModeSSLSocketFactory = factory;
        return this;
    }

    public ClientBuilder interceptors(HttpConnectionInterceptor ... interceptors) {
        for (HttpConnectionInterceptor interceptor : interceptors) {
            if (interceptor instanceof HttpConnectionRequestInterceptor) {
                this.requestInterceptors.add((HttpConnectionRequestInterceptor)interceptor);
            }
            if (!(interceptor instanceof HttpConnectionResponseInterceptor)) continue;
            this.responseInterceptors.add((HttpConnectionResponseInterceptor)interceptor);
        }
        return this;
    }

    public ClientBuilder connectTimeout(long connectTimeout, TimeUnit connectTimeoutUnit) {
        this.connectTimeout = connectTimeout;
        this.connectTimeoutUnit = connectTimeoutUnit;
        return this;
    }

    public ClientBuilder readTimeout(long readTimeout, TimeUnit readTimeoutUnit) {
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = readTimeoutUnit;
        return this;
    }

    public static ClientBuilder bluemix(String vcapServices) {
        return ClientBuilder.bluemix(vcapServices, null);
    }

    public static ClientBuilder bluemix(String vcapServices, String instanceName) {
        CloudFoundryServices services;
        Gson gson = new GsonBuilder().create();
        if (vcapServices == null) {
            throw new IllegalArgumentException("The vcapServices JSON information was null.");
        }
        try {
            services = (CloudFoundryServices)gson.fromJson(vcapServices, CloudFoundryServices.class);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("The vcapServices was not valid JSON.", e);
        }
        if (services.cloudantNoSQLDB == null || services.cloudantNoSQLDB.size() == 0) {
            throw new IllegalArgumentException("No Cloudant services information present.");
        }
        if (instanceName == null) {
            if (services.cloudantNoSQLDB.size() == 1) {
                CloudFoundryServices.CloudFoundryService service = services.cloudantNoSQLDB.get(0);
                if (service.credentials == null || service.credentials.url == null) {
                    throw new IllegalArgumentException("The Cloudant service instance information was invalid.");
                }
                return ClientBuilder.url(service.credentials.url);
            }
            throw new IllegalArgumentException("Multiple Cloudant service instances present. A service instance name must be specified.");
        }
        for (CloudFoundryServices.CloudFoundryService service : services.cloudantNoSQLDB) {
            if (!instanceName.equals(service.name)) continue;
            if (service.credentials == null || service.credentials.url == null) {
                throw new IllegalArgumentException("The Cloudant service instance information was invalid.");
            }
            return ClientBuilder.url(service.credentials.url);
        }
        throw new IllegalArgumentException(String.format("Cloudant service instance matching name %s was not found.", instanceName));
    }
}

