/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api;

import com.cloudant.client.api.Changes;
import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.DesignDocumentManager;
import com.cloudant.client.api.Search;
import com.cloudant.client.api.model.DbInfo;
import com.cloudant.client.api.model.FindByIndexOptions;
import com.cloudant.client.api.model.Index;
import com.cloudant.client.api.model.IndexField;
import com.cloudant.client.api.model.Params;
import com.cloudant.client.api.model.Permissions;
import com.cloudant.client.api.model.Response;
import com.cloudant.client.api.model.Shard;
import com.cloudant.client.api.views.AllDocsRequestBuilder;
import com.cloudant.client.api.views.ViewRequestBuilder;
import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.internal.URIBase;
import com.cloudant.client.internal.util.DeserializationTypes;
import com.cloudant.client.internal.views.AllDocsRequestBuilderImpl;
import com.cloudant.client.internal.views.AllDocsRequestResponse;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.cloudant.client.org.lightcouch.CouchDatabase;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public class Database {
    static final Logger log = Logger.getLogger(Database.class.getCanonicalName());
    private CouchDatabase db;
    private CloudantClient client;
    private final URI apiV2DBSecurityURI;

    Database(CloudantClient client, CouchDatabase db) {
        this.client = client;
        this.db = db;
        this.apiV2DBSecurityURI = ((URIBase)((URIBase)((URIBase)((URIBase)((URIBase)new URIBase(client.getBaseUri()).path("_api")).path("v2")).path("db")).path(db.getDbName())).path("_security")).build();
    }

    protected Database(Database db) {
        this(db.client, db.db);
    }

    public void setPermissions(String userNameorApikey, EnumSet<Permissions> permissions) {
        CouchDbUtil.assertNotEmpty(userNameorApikey, "userNameorApikey");
        CouchDbUtil.assertNotEmpty(permissions, "permissions");
        JsonArray jsonPermissions = new JsonArray();
        for (Permissions s : permissions) {
            JsonPrimitive permission = new JsonPrimitive(s.toString());
            jsonPermissions.add((JsonElement)permission);
        }
        JsonObject perms = this.getPermissionsObject();
        JsonElement elem = perms.get("cloudant");
        if (elem == null) {
            perms.addProperty("_id", "_security");
            elem = new JsonObject();
            perms.add("cloudant", elem);
        }
        elem.getAsJsonObject().add(userNameorApikey, (JsonElement)jsonPermissions);
        HttpConnection put = Http.PUT((URI)this.apiV2DBSecurityURI, (String)"application/json");
        put.setRequestBody(this.client.getGson().toJson((JsonElement)perms));
        this.client.couchDbClient.executeToResponse(put);
    }

    private JsonObject getPermissionsObject() {
        try {
            return this.client.couchDbClient.get(this.apiV2DBSecurityURI, JsonObject.class);
        }
        catch (CouchDbException exception) {
            if (exception.getMessage().toLowerCase(Locale.ENGLISH).contains("bad request")) {
                throw new UnsupportedOperationException("The methods getPermissions and setPermissions are not supported for this database, consider using the /db/_security endpoint.");
            }
            throw exception;
        }
    }

    public Map<String, EnumSet<Permissions>> getPermissions() {
        JsonObject perms = this.getPermissionsObject();
        return (Map)this.client.getGson().getAdapter(DeserializationTypes.PERMISSIONS_MAP_TOKEN).fromJsonTree((JsonElement)perms);
    }

    public List<Shard> getShards() {
        List<Shard> list;
        InputStream response = null;
        try {
            response = this.client.couchDbClient.get(((DatabaseURIHelper)new DatabaseURIHelper(this.db.getDBUri()).path("_shards")).build());
            list = CouchDbUtil.getResponseList(response, this.client.getGson(), DeserializationTypes.SHARDS);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
        return list;
    }

    public Shard getShard(String docId) {
        CouchDbUtil.assertNotEmpty(docId, "docId");
        return this.client.couchDbClient.get(((DatabaseURIHelper)((DatabaseURIHelper)new DatabaseURIHelper(this.db.getDBUri()).path("_shards")).path(docId)).build(), Shard.class);
    }

    public void createIndex(String indexName, String designDocName, String indexType, IndexField[] fields) {
        JsonObject indexDefn = this.getIndexDefinition(indexName, designDocName, indexType, fields);
        this.createIndex(indexDefn.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(String indexDefinition) {
        InputStream putresp;
        block3: {
            CouchDbUtil.assertNotEmpty(indexDefinition, "indexDefinition");
            putresp = null;
            URI uri = ((DatabaseURIHelper)new DatabaseURIHelper(this.db.getDBUri()).path("_index")).build();
            try {
                putresp = this.client.couchDbClient.executeToInputStream(CouchDbUtil.createPost(uri, indexDefinition, "application/json"));
                String result = CouchDbUtil.getAsString(putresp, "result");
                if (result.equalsIgnoreCase("created")) {
                    log.info(String.format("Created Index: '%s'", indexDefinition));
                    break block3;
                }
                log.warning(String.format("Index already exists : '%s'", indexDefinition));
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(putresp);
                throw throwable;
            }
        }
        CouchDbUtil.close(putresp);
    }

    public <T> List<T> findByIndex(String selectorJson, Class<T> classOfT) {
        return this.findByIndex(selectorJson, classOfT, new FindByIndexOptions());
    }

    public <T> List<T> findByIndex(String selectorJson, Class<T> classOfT, FindByIndexOptions options) {
        ArrayList<Object> arrayList;
        CouchDbUtil.assertNotNull(selectorJson, "selectorJson");
        selectorJson = selectorJson.trim();
        CouchDbUtil.assertNotEmpty(selectorJson, "selectorJson");
        CouchDbUtil.assertNotEmpty(options, "options");
        URI uri = ((DatabaseURIHelper)new DatabaseURIHelper(this.db.getDBUri()).path("_find")).build();
        JsonObject body = this.getFindByIndexBody(selectorJson, options);
        InputStream stream = null;
        try {
            stream = this.client.couchDbClient.executeToInputStream(CouchDbUtil.createPost(uri, body.toString(), "application/json"));
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            JsonArray jsonArray = new JsonParser().parse((Reader)reader).getAsJsonObject().getAsJsonArray("docs");
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement jsonElem : jsonArray) {
                JsonObject elem = jsonElem.getAsJsonObject();
                Object t = this.client.getGson().fromJson((JsonElement)elem, classOfT);
                list.add(t);
            }
            arrayList = list;
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(stream);
                throw throwable;
            }
        }
        CouchDbUtil.close(stream);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Index> listIndices() {
        List<Index> list;
        InputStream response = null;
        try {
            URI uri = ((DatabaseURIHelper)new DatabaseURIHelper(this.db.getDBUri()).path("_index")).build();
            response = this.client.couchDbClient.get(uri);
            list = CouchDbUtil.getResponseList(response, this.client.getGson(), DeserializationTypes.INDICES);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndex(String indexName, String designDocId) {
        CouchDbUtil.assertNotEmpty(indexName, "indexName");
        CouchDbUtil.assertNotEmpty(designDocId, "designDocId");
        URI uri = ((DatabaseURIHelper)((DatabaseURIHelper)((DatabaseURIHelper)((DatabaseURIHelper)new DatabaseURIHelper(this.db.getDBUri()).path("_index")).path(designDocId)).path("json")).path(indexName)).build();
        InputStream response = null;
        try {
            HttpConnection connection = Http.DELETE((URI)uri);
            response = this.client.couchDbClient.executeToInputStream(connection);
            CouchDbUtil.getResponse(response, com.cloudant.client.org.lightcouch.Response.class, this.client.getGson());
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
    }

    public Search search(String searchIndexId) {
        return new Search(this.client, this, searchIndexId);
    }

    public DesignDocumentManager getDesignDocumentManager() {
        return new DesignDocumentManager(this.client, this);
    }

    public ViewRequestBuilder getViewRequestBuilder(String designDoc, String viewName) {
        return new ViewRequestBuilder(this.client, this, designDoc, viewName);
    }

    public AllDocsRequestBuilder getAllDocsRequestBuilder() {
        return new AllDocsRequestBuilderImpl(new ViewQueryParameters<String, AllDocsRequestResponse.Revision>(this.client, this, "", "", String.class, AllDocsRequestResponse.Revision.class){

            @Override
            protected DatabaseURIHelper getViewURIBuilder() {
                return (DatabaseURIHelper)new DatabaseURIHelper(Database.this.db.getDBUri()).path("_all_docs");
            }
        });
    }

    public Changes changes() {
        return new Changes(this.client, this);
    }

    public <T> T find(Class<T> classType, String id) {
        return this.db.find(classType, id);
    }

    public <T> T find(Class<T> classType, String id, Params params) {
        CouchDbUtil.assertNotEmpty(params, "params");
        return this.db.find(classType, id, params.getInternalParams());
    }

    public <T> T find(Class<T> classType, String id, String rev) {
        return this.db.find(classType, id, rev);
    }

    public <T> T findAny(Class<T> classType, String uri) {
        return this.db.findAny(classType, uri);
    }

    public InputStream find(String id) {
        return this.db.find(id);
    }

    public InputStream find(String id, String rev) {
        return this.db.find(id, rev);
    }

    public boolean contains(String id) {
        return this.db.contains(id);
    }

    public Response save(Object object) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.db.save(object);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public Response save(Object object, int writeQuorum) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.client.couchDbClient.put(this.getDBUri(), object, true, writeQuorum);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public Response post(Object object) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.db.post(object);
        Response response = new Response(couchDbResponse);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response post(Object object, int writeQuorum) {
        Response response;
        CouchDbUtil.assertNotEmpty(object, "object");
        InputStream response2 = null;
        try {
            Response cloudantResponse;
            URI uri = ((DatabaseURIHelper)new DatabaseURIHelper(this.db.getDBUri()).query("w", writeQuorum)).build();
            response2 = this.client.couchDbClient.executeToInputStream(CouchDbUtil.createPost(uri, this.client.getGson().toJson(object), "application/json"));
            com.cloudant.client.org.lightcouch.Response couchDbResponse = CouchDbUtil.getResponse(response2, com.cloudant.client.org.lightcouch.Response.class, this.client.getGson());
            response = cloudantResponse = new Response(couchDbResponse);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response2);
            throw throwable;
        }
        CouchDbUtil.close(response2);
        return response;
    }

    public Response update(Object object) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.db.update(object);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public Response update(Object object, int writeQuorum) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.client.couchDbClient.put(this.getDBUri(), object, false, writeQuorum);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public Response remove(Object object) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.db.remove(object);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public Response remove(String id, String rev) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.db.remove(id, rev);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public List<Response> bulk(List<?> objects) {
        List<com.cloudant.client.org.lightcouch.Response> couchDbResponseList = this.db.bulk(objects, false);
        ArrayList<Response> cloudantResponseList = new ArrayList<Response>();
        for (com.cloudant.client.org.lightcouch.Response couchDbResponse : couchDbResponseList) {
            Response response = new Response(couchDbResponse);
            cloudantResponseList.add(response);
        }
        return cloudantResponseList;
    }

    public InputStream getAttachment(String docId, String attachmentName) {
        return this.getAttachment(docId, attachmentName, null);
    }

    public InputStream getAttachment(String docId, String attachmentName, String revId) {
        return this.db.getAttachment(docId, attachmentName, revId);
    }

    public Response saveAttachment(InputStream in, String name, String contentType) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.db.saveAttachment(in, name, contentType);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public Response saveAttachment(InputStream in, String name, String contentType, String docId, String docRev) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.db.saveAttachment(in, name, contentType, docId, docRev);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public Response removeAttachment(Object object, String attachmentName) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.db.removeAttachment(object, attachmentName);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public Response removeAttachment(String id, String rev, String attachmentName) {
        com.cloudant.client.org.lightcouch.Response couchDbResponse = this.db.removeAttachment(id, rev, attachmentName);
        Response response = new Response(couchDbResponse);
        return response;
    }

    public String invokeUpdateHandler(String updateHandlerUri, String docId, Params params) {
        CouchDbUtil.assertNotEmpty(params, "params");
        return this.db.invokeUpdateHandler(updateHandlerUri, docId, params.getInternalParams());
    }

    public URI getDBUri() {
        return this.db.getDBUri();
    }

    public DbInfo info() {
        return this.client.couchDbClient.get(new DatabaseURIHelper(this.db.getDBUri()).getDatabaseUri(), DbInfo.class);
    }

    public void ensureFullCommit() {
        this.db.ensureFullCommit();
    }

    private JsonObject getIndexDefinition(String indexName, String designDocName, String indexType, IndexField[] fields) {
        CouchDbUtil.assertNotEmpty(fields, "index fields");
        JsonObject indexObject = new JsonObject();
        if (indexName != null && !indexName.isEmpty()) {
            indexObject.addProperty("name", indexName);
        }
        if (designDocName != null && !designDocName.isEmpty()) {
            indexObject.addProperty("ddoc", designDocName);
        }
        if (indexType != null && !indexType.isEmpty()) {
            indexObject.addProperty("type", indexType);
        }
        JsonArray fieldsArray = new JsonArray();
        for (int i = 0; i < fields.length; ++i) {
            JsonObject fieldObject = new JsonObject();
            fieldObject.addProperty(fields[i].getName(), fields[i].getOrder().toString());
            fieldsArray.add((JsonElement)fieldObject);
        }
        JsonObject arrayOfFields = new JsonObject();
        arrayOfFields.add("fields", (JsonElement)fieldsArray);
        indexObject.add("index", (JsonElement)arrayOfFields);
        return indexObject;
    }

    private JsonObject getFindByIndexBody(String selectorJson, FindByIndexOptions options) {
        JsonArray fieldsArray = new JsonArray();
        if (options.getFields().size() > 0) {
            for (String string : options.getFields()) {
                JsonPrimitive jsonField = (JsonPrimitive)this.client.getGson().fromJson(string, JsonPrimitive.class);
                fieldsArray.add((JsonElement)jsonField);
            }
        }
        JsonArray sortArray = new JsonArray();
        if (options.getSort().size() > 0) {
            for (IndexField sort : options.getSort()) {
                JsonObject sortObject = new JsonObject();
                sortObject.addProperty(sort.getName(), sort.getOrder().toString());
                sortArray.add((JsonElement)sortObject);
            }
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject selectorObject = null;
        boolean isObject = true;
        try {
            selectorObject = (JsonObject)this.getGson().fromJson(selectorJson, JsonObject.class);
        }
        catch (JsonParseException e) {
            isObject = false;
        }
        if (!isObject) {
            if (selectorJson.startsWith("\"selector\"")) {
                selectorJson = selectorJson.substring(selectorJson.indexOf(":") + 1, selectorJson.length()).trim();
                selectorObject = (JsonObject)this.getGson().fromJson(selectorJson, JsonObject.class);
            } else {
                throw new JsonParseException("selectorJson should be valid json or like \"selector\": {...} ");
            }
        }
        if (selectorObject.has("selector")) {
            jsonObject.add("selector", selectorObject.get("selector"));
        } else {
            jsonObject.add("selector", (JsonElement)selectorObject);
        }
        if (fieldsArray.size() > 0) {
            jsonObject.add("fields", (JsonElement)fieldsArray);
        }
        if (sortArray.size() > 0) {
            jsonObject.add("sort", (JsonElement)sortArray);
        }
        if (options.getLimit() != null) {
            jsonObject.addProperty("limit", (Number)options.getLimit());
        }
        if (options.getSkip() != null) {
            jsonObject.addProperty("skip", (Number)options.getSkip());
        }
        if (options.getReadQuorum() != null) {
            jsonObject.addProperty("r", (Number)options.getReadQuorum());
        }
        if (options.getUseIndex() != null) {
            jsonObject.add("use_index", (JsonElement)this.getGson().fromJson(options.getUseIndex(), JsonElement.class));
        }
        return jsonObject;
    }

    Gson getGson() {
        return this.client.getGson();
    }
}

