/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal;

import com.cloudant.client.internal.HierarchicalUriComponents;
import com.cloudant.client.org.lightcouch.Params;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

abstract class URIBaseMethods<T extends URIBaseMethods> {
    private static final String _design_prefix_encoded = "_design%2F";
    private static final String _local_prefix_encoded = "_local%2F";
    Params qParams = new Params();
    String completeQuery = "";
    String path = "";
    URI baseUri;

    URIBaseMethods() {
    }

    public abstract T returnThis();

    public T path(String path) {
        this.path = path.length() == 0 ? this.path + this.encodePath(path) : this.path + "/" + this.encodePath(path);
        return this.returnThis();
    }

    public T query(String name, Object value) {
        this.query(name, value, true);
        return this.returnThis();
    }

    public T query(String name, Object value, boolean replace) {
        if (name != null && value != null) {
            if (replace) {
                this.qParams.replaceOrAdd(name, value.toString());
            } else {
                this.qParams.addParam(name, value.toString());
            }
        }
        return this.returnThis();
    }

    public URI getUri() {
        return this.baseUri;
    }

    String encodePath(String in) {
        try {
            String encodedString = HierarchicalUriComponents.encodeUriComponent(in, "UTF-8", HierarchicalUriComponents.Type.PATH_SEGMENT);
            if (encodedString.startsWith(_design_prefix_encoded) || encodedString.startsWith(_local_prefix_encoded)) {
                return encodedString.replaceFirst("%2F", "/");
            }
            return encodedString;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Couldn't encode ID " + in, uee);
        }
    }

    public URI build() {
        try {
            String uriString = String.format("%s%s", this.baseUri.toASCIIString(), this.path.isEmpty() ? "" : this.path);
            if (this.qParams != null && this.qParams.size() > 0) {
                uriString = !this.completeQuery.isEmpty() ? String.format("%s?%s&%s", uriString, this.getJoinedQuery(this.qParams.getParams()), this.completeQuery) : String.format("%s?%s", uriString, this.getJoinedQuery(this.qParams.getParams()));
            } else if (!this.completeQuery.isEmpty()) {
                uriString = String.format("%s?%s", uriString, this.completeQuery);
            }
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String getJoinedQuery(List<String> parts) {
        StringBuilder queryBuilder = new StringBuilder();
        for (String query : parts) {
            if (query == null || query.isEmpty()) continue;
            queryBuilder.append(query);
            queryBuilder.append("&");
        }
        queryBuilder.deleteCharAt(queryBuilder.length() - 1);
        return queryBuilder.toString();
    }
}

