/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.model.Document;
import com.cloudant.client.api.views.AllDocsRequest;
import com.cloudant.client.api.views.AllDocsResponse;
import com.cloudant.client.api.views.ViewRequest;
import com.cloudant.client.api.views.ViewResponse;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.cloudant.client.internal.views.ViewRequestImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllDocsRequestResponse
implements AllDocsRequest,
AllDocsResponse {
    private final ViewRequest<String, Revision> request;
    private ViewResponse<String, Revision> response = null;

    AllDocsRequestResponse(ViewQueryParameters<String, Revision> parameters) {
        this.request = new ViewRequestImpl<String, Revision>(parameters);
    }

    @Override
    public AllDocsResponse getResponse() throws IOException {
        this.response = this.request.getResponse();
        return this;
    }

    @Override
    public List<Document> getDocs() {
        return this.response.getDocs();
    }

    @Override
    public Map<String, String> getIdsAndRevs() {
        HashMap<String, String> docIdsAndRevs = new HashMap<String, String>();
        for (ViewResponse.Row<String, Revision> row : this.response.getRows()) {
            Revision rev = row.getValue();
            if (rev == null) continue;
            docIdsAndRevs.put(row.getKey(), rev.get());
        }
        return docIdsAndRevs;
    }

    @Override
    public <D> List<D> getDocsAs(Class<D> docType) {
        return this.response.getDocsAs(docType);
    }

    @Override
    public List<String> getDocIds() {
        return this.response.getKeys();
    }

    public static final class Revision {
        private String rev;

        public String get() {
            return this.rev;
        }
    }
}

