/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.views.Key;
import com.cloudant.client.api.views.RequestBuilder;
import com.cloudant.client.api.views.SettableViewParameters;
import com.cloudant.client.internal.views.ViewQueryParameters;

public abstract class CommonViewRequestBuilder<K, V, RB extends RequestBuilder<RB>>
implements SettableViewParameters.Common<K, RB>,
SettableViewParameters.Paginated<K, RB>,
SettableViewParameters.Unpaginated<K, RB>,
SettableViewParameters.Reduceable<K, RB> {
    protected final ViewQueryParameters<K, V> viewQueryParameters;

    protected CommonViewRequestBuilder(ViewQueryParameters<K, V> parameters) {
        this.viewQueryParameters = parameters;
    }

    public abstract RB returnThis();

    public void validateQuery() {
        if (this.viewQueryParameters.group_level != null && !Key.ComplexKey.class.isAssignableFrom(this.viewQueryParameters.getKeyType())) {
            throw new IllegalArgumentException("Group level is only valid when using a complex key");
        }
        if (this.viewQueryParameters.reduce != null && this.viewQueryParameters.getReduce() && this.viewQueryParameters.getIncludeDocs()) {
            throw new IllegalArgumentException("Cannot include_docs with reduce=true");
        }
        if (!this.viewQueryParameters.getReduce() && (this.viewQueryParameters.getGroup() || this.viewQueryParameters.getGroupLevel() != null)) {
            throw new IllegalArgumentException("Cannot use group or group_level with reduce=false");
        }
    }

    @Override
    public RB descending(boolean descending) {
        this.viewQueryParameters.setDescending(descending);
        return this.returnThis();
    }

    @Override
    public RB endKey(K endkey) {
        this.viewQueryParameters.setEndKey(endkey);
        return this.returnThis();
    }

    @Override
    public RB endKeyDocId(String endkey_docid) {
        this.viewQueryParameters.setEndKeyDocId(endkey_docid);
        return this.returnThis();
    }

    @Override
    public RB group(boolean group) {
        this.viewQueryParameters.setGroup(group);
        return this.returnThis();
    }

    @Override
    public RB groupLevel(int group_level) {
        this.viewQueryParameters.setGroupLevel(group_level);
        return this.returnThis();
    }

    @Override
    public RB includeDocs(boolean include_docs) {
        this.viewQueryParameters.setIncludeDocs(include_docs);
        return this.returnThis();
    }

    @Override
    public RB inclusiveEnd(boolean inclusive_end) {
        this.viewQueryParameters.setInclusiveEnd(inclusive_end);
        return this.returnThis();
    }

    @Override
    public RB keys(K ... keys) {
        this.viewQueryParameters.setKeys(keys);
        return this.returnThis();
    }

    @Override
    public RB reduce(boolean reduce) {
        this.viewQueryParameters.setReduce(reduce);
        return this.returnThis();
    }

    @Override
    public RB stale(String stale) {
        this.viewQueryParameters.setStale(stale);
        return this.returnThis();
    }

    @Override
    public RB startKey(K startkey) {
        this.viewQueryParameters.setStartKey(startkey);
        return this.returnThis();
    }

    @Override
    public RB startKeyDocId(String startkey_docid) {
        this.viewQueryParameters.setStartKeyDocId(startkey_docid);
        return this.returnThis();
    }

    @Override
    public RB limit(int limit) {
        this.viewQueryParameters.setLimit(limit);
        return this.returnThis();
    }

    @Override
    public RB skip(long skip) {
        this.viewQueryParameters.setSkip(skip);
        return this.returnThis();
    }

    @Override
    public RB rowsPerPage(int rowsPerPage) {
        this.viewQueryParameters.setRowsPerPage(rowsPerPage);
        return this.returnThis();
    }
}

