/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.internal.views.ViewQueryParameters;

final class PageMetadata<K, V> {
    final ViewQueryParameters<K, V> pageRequestParameters;
    final long pageNumber;
    final PagingDirection direction;

    PageMetadata(PagingDirection direction, long pageNumber, ViewQueryParameters<K, V> pageRequestParameters) {
        this.direction = direction;
        this.pageNumber = pageNumber;
        this.pageRequestParameters = pageRequestParameters;
    }

    static <K, V> ViewQueryParameters<K, V> forwardPaginationQueryParameters(ViewQueryParameters<K, V> initialQueryParameters, K startkey, String startkey_docid) {
        ViewQueryParameters<K, V> pageParameters = initialQueryParameters.copy();
        pageParameters.setStartKey(startkey);
        pageParameters.setStartKeyDocId(startkey_docid);
        return pageParameters;
    }

    static <K, V> ViewQueryParameters<K, V> reversePaginationQueryParameters(ViewQueryParameters<K, V> initialQueryParameters, K startkey, String startkey_docid) {
        ViewQueryParameters<K, V> reversedParameters = PageMetadata.forwardPaginationQueryParameters(initialQueryParameters, startkey, startkey_docid);
        reversedParameters.setDescending(!initialQueryParameters.getDescending());
        reversedParameters.setInclusiveEnd(true);
        if (startkey != null) {
            reversedParameters.endkey = initialQueryParameters.startkey;
        }
        if (startkey_docid != null) {
            reversedParameters.setEndKeyDocId(initialQueryParameters.startkey_docid);
        }
        return reversedParameters;
    }

    static enum PagingDirection {
        FORWARD,
        BACKWARD;

    }
}

