/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.org.lightcouch;

import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.org.lightcouch.CouchDbClient;
import com.cloudant.client.org.lightcouch.ReplicationResult;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Replication {
    static final Logger log = Logger.getLogger(Replication.class.getCanonicalName());
    private String source;
    private String target;
    private Boolean cancel;
    private Boolean continuous;
    private String filter;
    private JsonObject queryParams;
    private String[] docIds;
    private String proxy;
    private Boolean createTarget;
    private Integer sinceSeq;
    private JsonObject targetOauth;
    private String consumerSecret;
    private String consumerKey;
    private String tokenSecret;
    private String token;
    private CouchDbClient client;

    public Replication(CouchDbClient client) {
        this.client = client;
    }

    public ReplicationResult trigger() {
        ReplicationResult replicationResult;
        CouchDbUtil.assertNotEmpty(this.source, "Source");
        CouchDbUtil.assertNotEmpty(this.target, "Target");
        InputStream response = null;
        try {
            JsonObject json = this.createJson();
            if (log.isLoggable(Level.FINE)) {
                log.fine(json.toString());
            }
            URI uri = ((DatabaseURIHelper)new DatabaseURIHelper(this.client.getBaseUri()).path("_replicate")).build();
            response = this.client.post(uri, json.toString());
            InputStreamReader reader = new InputStreamReader(response, "UTF-8");
            replicationResult = (ReplicationResult)this.client.getGson().fromJson((Reader)reader, ReplicationResult.class);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(response);
                throw throwable;
            }
        }
        CouchDbUtil.close(response);
        return replicationResult;
    }

    public Replication source(String source) {
        this.source = source;
        return this;
    }

    public Replication target(String target) {
        this.target = target;
        return this;
    }

    public Replication continuous(Boolean continuous) {
        this.continuous = continuous;
        return this;
    }

    public Replication filter(String filter) {
        this.filter = filter;
        return this;
    }

    public Replication queryParams(String queryParams) {
        this.queryParams = (JsonObject)this.client.getGson().fromJson(queryParams, JsonObject.class);
        return this;
    }

    public Replication queryParams(Map<String, Object> queryParams) {
        this.queryParams = this.client.getGson().toJsonTree(queryParams).getAsJsonObject();
        return this;
    }

    public Replication docIds(String ... docIds) {
        this.docIds = docIds;
        return this;
    }

    public Replication proxy(String proxy) {
        this.proxy = proxy;
        return this;
    }

    public Replication cancel(Boolean cancel) {
        this.cancel = cancel;
        return this;
    }

    public Replication createTarget(Boolean createTarget) {
        this.createTarget = createTarget;
        return this;
    }

    public Replication sinceSeq(Integer sinceSeq) {
        this.sinceSeq = sinceSeq;
        return this;
    }

    public Replication targetOauth(String consumerSecret, String consumerKey, String tokenSecret, String token) {
        this.targetOauth = new JsonObject();
        this.consumerSecret = consumerKey;
        this.consumerKey = consumerKey;
        this.tokenSecret = tokenSecret;
        this.token = token;
        return this;
    }

    private JsonObject createJson() {
        JsonObject json = new JsonObject();
        this.addProperty(json, "source", this.source);
        this.addProperty(json, "cancel", this.cancel);
        this.addProperty(json, "continuous", this.continuous);
        this.addProperty(json, "filter", this.filter);
        if (this.queryParams != null) {
            json.add("query_params", (JsonElement)this.queryParams);
        }
        if (this.docIds != null) {
            json.add("doc_ids", this.client.getGson().toJsonTree((Object)this.docIds, String[].class));
        }
        this.addProperty(json, "proxy", this.proxy);
        this.addProperty(json, "since_seq", this.sinceSeq);
        this.addProperty(json, "create_target", this.createTarget);
        if (this.targetOauth != null) {
            JsonObject auth = new JsonObject();
            JsonObject oauth = new JsonObject();
            this.addProperty(oauth, "consumer_secret", this.consumerSecret);
            this.addProperty(oauth, "consumer_key", this.consumerKey);
            this.addProperty(oauth, "token_secret", this.tokenSecret);
            this.addProperty(oauth, "token", this.token);
            this.addProperty(this.targetOauth, "url", this.target);
            auth.add("oauth", (JsonElement)oauth);
            this.targetOauth.add("auth", (JsonElement)auth);
            json.add("target", (JsonElement)this.targetOauth);
        } else {
            this.addProperty(json, "target", this.target);
        }
        return json;
    }

    private void addProperty(JsonObject json, String name, Object value) {
        if (value != null) {
            if (value instanceof Boolean) {
                json.addProperty(name, (Boolean)value);
            } else if (value instanceof String) {
                json.addProperty(name, (String)value);
            } else if (value instanceof Integer) {
                json.addProperty(name, (Number)((Integer)value));
            }
        }
    }
}

