/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.DepthTrackingEnv;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import com.cloudbees.groovy.cps.sandbox.Invoker;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class CallEnv
implements DepthTrackingEnv {
    private final Continuation returnAddress;
    private Map<String, Class> types;
    private final Env caller;
    @CheckForNull
    private final SourceLocation callSiteLoc;
    private Invoker invoker;
    int depth;
    private static final long serialVersionUID = 1L;

    public CallEnv(Env caller, Continuation returnAddress, SourceLocation loc) {
        this(caller, returnAddress, loc, 1);
    }

    public CallEnv(Env caller, Continuation returnAddress, SourceLocation loc, int localsCount) {
        this.caller = caller;
        this.returnAddress = returnAddress;
        this.callSiteLoc = loc;
        Invoker invoker = this.invoker = caller == null ? Invoker.INSTANCE : caller.getInvoker();
        assert (returnAddress != null);
        this.types = localsCount <= 0 ? Collections.EMPTY_MAP : Maps.newHashMapWithExpectedSize((int)localsCount);
        this.depth = caller instanceof DepthTrackingEnv ? ((DepthTrackingEnv)caller).getDepth() + 1 : 1;
    }

    protected Map<String, Class> getTypes() {
        if (this.types == null) {
            this.types = Collections.EMPTY_MAP;
        }
        return this.types;
    }

    protected Map<String, Class> getTypesForMutation() {
        if (this.types == null || this.types == Collections.EMPTY_MAP) {
            this.types = new HashMap<String, Class>(2);
        }
        return this.types;
    }

    @Override
    public Class getLocalVariableType(String name) {
        return this.getTypes().get(name);
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public final Continuation getReturnAddress() {
        return this.returnAddress;
    }

    @Override
    public final Continuation getBreakAddress(String label) {
        throw new IllegalStateException("unexpected break statement");
    }

    @Override
    public final Continuation getContinueAddress(String label) {
        throw new IllegalStateException("unexpected continue statement");
    }

    @Override
    public final Continuation getExceptionHandler(Class<? extends Throwable> type) {
        if (this.caller == null) {
            return new Continuation(){

                @Override
                public Next receive(Object o) {
                    return Next.unhandledException((Throwable)o);
                }
            };
        }
        return this.caller.getExceptionHandler(type);
    }

    @Override
    public void buildStackTraceElements(List<StackTraceElement> stack, int depth) {
        if (this.callSiteLoc != null) {
            stack.add(this.callSiteLoc.toStackTrace());
        }
        if (this.caller != null && depth > 1) {
            this.caller.buildStackTraceElements(stack, depth - 1);
        }
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        return this.callSiteLoc != null ? super.toString() + " @" + this.callSiteLoc : super.toString();
    }
}

