/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class Caller {
    private static final ThreadLocal<Info> store = ThreadLocal.withInitial(Info::new);

    public static boolean isAsynchronous(Object receiver, String method, Object ... args) {
        Info i = store.get();
        return i.receiver != null && receiver == i.receiver.get() && method.equals(i.method) && Caller.arrayShallowEquals(i.args, args);
    }

    private static boolean arrayShallowEquals(Reference<Object>[] a, Object[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].get() == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isAsynchronous(Object receiver, String method) {
        Info i = store.get();
        return i.receiver != null && receiver == i.receiver.get() && method.equals(i.method) && i.args.length == 0;
    }

    public static boolean isAsynchronous(Object receiver, String method, Object arg1) {
        Info i = store.get();
        return i.receiver != null && receiver == i.receiver.get() && method.equals(i.method) && i.args.length == 1 && i.args[0].get() == arg1;
    }

    public static boolean isAsynchronous(Object receiver, String method, Object arg1, Object arg2) {
        Info i = store.get();
        return i.receiver != null && receiver == i.receiver.get() && method.equals(i.method) && i.args.length == 2 && i.args[0].get() == arg1 && i.args[1].get() == arg2;
    }

    static void record(Object receiver, String method, Object[] args) {
        Info c = store.get();
        c.receiver = new WeakReference<Object>(receiver);
        c.method = method;
        c.args = new WeakReference[args.length];
        for (int i = 0; i < args.length; ++i) {
            c.args[i] = new WeakReference<Object>(args[i]);
        }
    }

    static class Info {
        private Reference<Object> receiver;
        private String method;
        private Reference<Object>[] args;

        Info() {
        }
    }
}

