/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.maven.license;

import com.cloudbees.maven.license.CompleterDelegate;
import com.cloudbees.maven.license.FilterDelegate;
import com.cloudbees.maven.license.GeneratorDelegate;
import com.cloudbees.maven.license.LicenseScript;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.groovy.control.CompilerConfiguration;

@Mojo(name="process", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ProcessMojo
extends AbstractMojo {
    @Component
    public MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    public MavenSession session;
    @Component
    public ProjectBuilder projectBuilder;
    @Component
    public ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}")
    public ArtifactRepository localRepository;
    @Parameter(defaultValue="${license.script}")
    public File script;
    @Parameter
    public String inlineScript;
    @Parameter
    public boolean requireCompleteLicenseInfo;
    @Parameter(defaultValue="${license.generateLicenseXml}")
    public File generateLicenseXml;
    @Parameter(defaultValue="${license.generateLicenseHtml}")
    public File generateLicenseHtml;
    @Parameter(defaultValue="${license.disableCheck}")
    public boolean disableCheck;
    @Parameter(defaultValue="${license.attach}")
    public boolean attach;

    public void execute() throws MojoExecutionException {
        if (this.disableCheck) {
            return;
        }
        GroovyShell shell = this.createShell(LicenseScript.class);
        List<LicenseScript> comp = this.parseScripts(this.script, shell);
        if (this.generateLicenseHtml != null && this.generateLicenseXml == null) {
            try {
                this.generateLicenseXml = File.createTempFile("license", "xml");
                this.generateLicenseXml.deleteOnExit();
            }
            catch (IOException e2) {
                throw new MojoExecutionException("Failed to generate a temporary file", (Exception)e2);
            }
        }
        if (this.generateLicenseXml != null) {
            try {
                comp.add((LicenseScript)shell.parse(((Object)((Object)this)).getClass().getResource("xmlgen.groovy").toURI()));
            }
            catch (IOException | URISyntaxException e3) {
                throw new MojoExecutionException("Failed to retrieve xmlgen.groovy", e3);
            }
        }
        if (this.generateLicenseHtml != null) {
            try {
                comp.add((LicenseScript)shell.parse(((Object)((Object)this)).getClass().getResource("htmlgen.groovy").toURI()));
            }
            catch (IOException | URISyntaxException e4) {
                throw new MojoExecutionException("Failed to retrieve htmlgen.groovy", e4);
            }
        }
        if (this.inlineScript != null) {
            comp.add((LicenseScript)shell.parse(this.inlineScript, "inlineScript"));
        }
        for (LicenseScript licenseScript : comp) {
            licenseScript.project = this.project;
            licenseScript.mojo = this;
            licenseScript.run();
        }
        ArrayList<MavenProject> dependencies = new ArrayList<MavenProject>();
        for (LicenseScript licenseScript : comp) {
            licenseScript.runCompleter(new CompleterDelegate(this.project, this.project));
        }
        dependencies.add(this.project);
        HashMap<Artifact, MavenProject> hashMap = new HashMap<Artifact, MavenProject>();
        for (Artifact a : this.project.getArtifacts()) {
            Artifact pom = this.artifactFactory.createProjectArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion());
            try {
                DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
                buildingRequest.setLocalRepository(this.localRepository);
                buildingRequest.setProcessPlugins(false);
                hashMap.put(a, this.projectBuilder.build(pom, (ProjectBuildingRequest)buildingRequest).getProject());
            }
            catch (ProjectBuildingException x) {
                this.getLog().warn((CharSequence)x.getMessage());
            }
        }
        for (LicenseScript s : comp) {
            s.runFilter(new FilterDelegate(hashMap));
        }
        hashMap.entrySet().removeIf(e -> ((Artifact)e.getKey()).isOptional());
        for (Object e5 : hashMap.values()) {
            for (LicenseScript s : comp) {
                s.runCompleter(new CompleterDelegate((MavenProject)e5, this.project));
            }
        }
        dependencies.addAll(hashMap.values());
        if (this.requireCompleteLicenseInfo) {
            ArrayList<MavenProject> arrayList = new ArrayList<MavenProject>();
            for (MavenProject d : dependencies) {
                if (!d.getLicenses().isEmpty()) continue;
                arrayList.add(d);
            }
            if (!arrayList.isEmpty()) {
                StringBuilder buf = new StringBuilder("The following dependencies are missing license information:\n");
                for (MavenProject p : arrayList) {
                    buf.append("  " + p.getGroupId() + ':' + p.getArtifactId() + ':' + p.getVersion());
                    for (p = p.getParent(); p != null; p = p.getParent()) {
                        buf.append(" -> " + p.getGroupId() + ':' + p.getArtifactId() + ':' + p.getVersion());
                    }
                    buf.append('\n');
                }
                buf.append("\nAdd/update your completion script to fill them, or run with -Dlicense.disableCheck to bypass the check.");
                throw new MojoExecutionException(buf.toString());
            }
        }
        for (LicenseScript s : comp) {
            s.runGenerator(new GeneratorDelegate(dependencies));
        }
        if (this.attach) {
            if (this.generateLicenseXml != null) {
                this.projectHelper.attachArtifact(this.project, "license.xml", null, this.generateLicenseXml);
            }
            if (this.generateLicenseHtml != null) {
                this.projectHelper.attachArtifact(this.project, "license.html", null, this.generateLicenseHtml);
            }
        }
    }

    private List<LicenseScript> parseScripts(File src, GroovyShell shell) throws MojoExecutionException {
        ArrayList<LicenseScript> comp = new ArrayList<LicenseScript>();
        if (src != null) {
            try {
                if (src.isDirectory()) {
                    for (File script : src.listFiles()) {
                        comp.add((LicenseScript)shell.parse(script));
                    }
                } else {
                    comp.add((LicenseScript)shell.parse(src));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse the script: " + src, (Exception)e);
            }
        }
        return comp;
    }

    private <T extends Script> GroovyShell createShell(Class<T> baseType) {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setScriptBaseClass(baseType.getName());
        return new GroovyShell(((Object)((Object)this)).getClass().getClassLoader(), new Binding(), cc);
    }
}

