/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.InvalidStateError;
import com.codeborne.selenide.impl.Arguments;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class SelectOptionByValue
implements Command<Void> {
    private static final JavaScript selectOptionByValue = new JavaScript("select-options-by-value.js");

    @Override
    public @Nullable Void execute(SelenideElement proxy, WebElementSource selectField, @Nullable Object[] args) {
        Arguments arguments = new Arguments(args);
        List<String> values = Util.merge(Objects.requireNonNull((String)arguments.nth(0)), Objects.requireNonNull((String[])arguments.nth(1)));
        this.selectOptionByValue(selectField, values);
        return null;
    }

    private void selectOptionByValue(WebElementSource selectField, List<String> values) {
        Map error = Objects.requireNonNull((Map)selectOptionByValue.execute(selectField.driver(), selectField.getWebElement(), values));
        if (error.containsKey("nonSelect")) {
            throw new IllegalArgumentException("Cannot select option from a non-select element");
        }
        if (error.containsKey("disabledSelect")) {
            throw new InvalidStateError(selectField.description(), "Cannot select option in a disabled select");
        }
        if (error.containsKey("disabledOptions")) {
            List value = (List)Util.cast(error.get("disabledOptions"));
            String elementDescription = String.format("%s/option[value:%s]", selectField.description(), Util.arrayToString(value));
            throw new InvalidStateError(elementDescription, "Cannot select a disabled option");
        }
        if (error.containsKey("optionsNotFound")) {
            List value = (List)Util.cast(error.get("optionsNotFound"));
            String elementDescription = String.format("%s/option[value:%s]", selectField.getSearchCriteria(), Util.arrayToString(value));
            throw new ElementNotFound(selectField.getAlias(), elementDescription, Condition.exist);
        }
    }
}

