/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.File;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadFile
implements Command<File> {
    private static final Logger log = LoggerFactory.getLogger(UploadFile.class);
    private final ElementDescriber describe = Plugins.inject(ElementDescriber.class);

    @Override
    public File execute(SelenideElement proxy, WebElementSource locator, Object @Nullable [] args) {
        File[] file = this.getFiles(args);
        this.checkFilesGiven(file);
        this.checkFilesExist(file);
        WebElement inputField = locator.getWebElement();
        Driver driver = locator.driver();
        this.checkValidInputField(driver, inputField);
        String fileNames = Stream.of(file).map(this::canonicalPath).collect(Collectors.joining("\n"));
        this.uploadFiles(driver.config(), inputField, fileNames);
        return this.getCanonicalFile(file[0]);
    }

    private File getCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            log.warn("Failed to get canonical representation of file {}", (Object)f, (Object)e);
            return f;
        }
    }

    private void checkFilesGiven(File[] file) {
        if (file.length == 0) {
            throw new IllegalArgumentException("No files to upload");
        }
    }

    private void checkFilesExist(File[] file) {
        for (File f : file) {
            if (f.exists()) continue;
            throw new IllegalArgumentException("File not found: " + f.getAbsolutePath());
        }
    }

    private File[] getFiles(Object @Nullable [] args) {
        File[] fileArray;
        if (args instanceof File[]) {
            File[] multipleFiles = (File[])args;
            fileArray = multipleFiles;
        } else {
            fileArray = (File[])Util.firstOf(args);
        }
        return fileArray;
    }

    private String canonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot get canonical path of file " + String.valueOf(file), e);
        }
    }

    protected void uploadFiles(Config config, WebElement inputField, String fileNames) {
        Stopwatch stopwatch = new Stopwatch(config.timeout());
        while (true) {
            try {
                inputField.sendKeys(new CharSequence[]{fileNames});
            }
            catch (ElementNotInteractableException notInteractable) {
                if (stopwatch.isTimeoutReached()) {
                    throw notInteractable;
                }
                stopwatch.sleep(config.pollingInterval());
                if (!stopwatch.isTimeoutReached()) continue;
            }
            break;
        }
    }

    private void checkValidInputField(Driver driver, WebElement inputField) {
        if (!"input".equalsIgnoreCase(inputField.getTagName())) {
            throw new IllegalArgumentException("Cannot upload file because " + this.describe.briefly(driver, inputField) + " is not an INPUT");
        }
    }
}

