/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.TextCheck;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.impl.Html;
import org.openqa.selenium.WebElement;

public class Value
extends WebElementCondition {
    private final String expectedValue;

    public Value(String expectedValue) {
        super("value");
        this.expectedValue = expectedValue;
    }

    @Override
    public CheckResult check(Driver driver, WebElement element) {
        String value = this.getValueAttribute(element);
        String actualValue = String.format("%s=\"%s\"", this.getName(), value);
        return new CheckResult(this.match(driver.config().textCheck(), value), (Object)actualValue);
    }

    private boolean match(TextCheck textCheck, String value) {
        return switch (textCheck) {
            default -> throw new IncompatibleClassChangeError();
            case TextCheck.FULL_TEXT -> Html.text.equals(value, this.expectedValue);
            case TextCheck.PARTIAL_TEXT -> Html.text.contains(value, this.expectedValue);
        };
    }

    @Override
    public String toString() {
        return String.format("%s=\"%s\"", this.getName(), this.expectedValue);
    }

    private String getValueAttribute(WebElement element) {
        String attr = element.getAttribute("value");
        return attr == null ? "" : attr;
    }
}

