/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.localstorage;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.LocalStorage;
import com.codeborne.selenide.ObjectCondition;

public class Item
implements ObjectCondition<LocalStorage> {
    private final String item;

    public Item(String item) {
        this.item = item;
    }

    @Override
    public String description() {
        return String.format("should have item '%s'", this.item);
    }

    @Override
    public String negativeDescription() {
        return String.format("should not have item '%s'", this.item);
    }

    private String actualValue(LocalStorage localStorage) {
        return localStorage.getItems().toString();
    }

    @Override
    public String expectedValue() {
        return this.item;
    }

    @Override
    public CheckResult check(LocalStorage localStorage) {
        return this.result(localStorage, localStorage.containsItem(this.item), this.actualValue(localStorage));
    }

    @Override
    public String describe(LocalStorage localStorage) {
        return "localStorage";
    }
}

