/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.ex.FileNotDownloadedError;
import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.DownloadDetector;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class Downloads {
    private final List<DownloadedFile> files = new CopyOnWriteArrayList<DownloadedFile>();

    public Downloads() {
    }

    public Downloads(List<DownloadedFile> files) {
        this.files.addAll(files);
    }

    public void clear() {
        this.files.clear();
    }

    public void add(DownloadedFile file) {
        this.files.add(file);
    }

    public List<DownloadedFile> files() {
        return this.files;
    }

    public List<DownloadedFile> files(FileFilter fileFilter) {
        return this.files.stream().filter(fileFilter::match).collect(Collectors.toList());
    }

    public Optional<DownloadedFile> firstMatchingFile(FileFilter fileFilter) {
        return this.files.stream().filter(fileFilter::match).sorted(new DownloadDetector()).findFirst();
    }

    public String filesAsString() {
        if (this.files.isEmpty()) {
            return "[]";
        }
        if (this.files.size() == 1) {
            return String.valueOf(this.files.get(0)) + " (1 file at " + System.currentTimeMillis() + ")";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (DownloadedFile file : this.files) {
            sb.append("\n  #").append(++i).append("  ").append(file);
        }
        sb.append("\n  (").append(this.files.size()).append(" files at ").append(System.currentTimeMillis()).append(")\n");
        return sb.toString();
    }

    public int size() {
        return this.files.size();
    }

    public File firstDownloadedFile(long timeout, FileFilter fileFilter) {
        return this.firstMatchingFile(fileFilter).orElseThrow(() -> {
            String message = String.format("Failed to download file%s in %d ms.", fileFilter.description(), timeout);
            return new FileNotDownloadedError(message.trim(), timeout);
        }).getFile();
    }
}

