/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.Lazy;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;

public class LazyCollectionSnapshot
implements CollectionSource {
    private final CollectionSource delegate;
    private final Lazy<List<WebElement>> elementsSnapshot;

    LazyCollectionSnapshot(CollectionSource delegate) {
        this.delegate = delegate;
        this.elementsSnapshot = Lazy.lazyEvaluated(() -> new ArrayList<WebElement>(delegate.getElements()));
    }

    @Override
    public List<WebElement> getElements() {
        return this.elementsSnapshot.get();
    }

    @Override
    public WebElement getElement(int index) {
        return this.getElements().get(index);
    }

    @Override
    public String getSearchCriteria() {
        return this.delegate.getSearchCriteria();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Driver driver() {
        return this.delegate.driver();
    }

    @Override
    public Alias getAlias() {
        return this.delegate.getAlias();
    }

    @Override
    public void setAlias(String alias) {
        this.delegate.setAlias(alias);
    }
}

