/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Container;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.PageObjectException;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.ElementsContainerCollection;
import com.codeborne.selenide.impl.SelenideAnnotations;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebElementWrapper;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public interface PageObjectFactory {
    public <PageObjectClass> PageObjectClass page(Driver var1, Class<PageObjectClass> var2);

    public <PageObjectClass, T extends PageObjectClass> PageObjectClass page(Driver var1, T var2);

    public Container createElementsContainer(Driver var1, WebElementSource var2, Field var3, By var4);

    default public <ContainerClass extends Container> ContainerClass createElementsContainer(Driver driver, By selector, int index, Class<ContainerClass> containerClass, Type[] genericTypes) {
        ElementFinder self = new ElementFinder(driver, null, selector, index, SelenideAnnotations.isShadowRoot(containerClass), null);
        return this.initElementsContainer(driver, self, containerClass, genericTypes);
    }

    default public <ContainerClass extends Container> ContainerClass createElementsContainer(Driver driver, WebElement webElement, Class<ContainerClass> containerClass, Type[] genericTypes) {
        WebElementWrapper self = new WebElementWrapper(driver, webElement, null, SelenideAnnotations.isShadowRoot(containerClass));
        return this.initElementsContainer(driver, self, containerClass, genericTypes);
    }

    private <ContainerClass extends Container> ContainerClass initElementsContainer(Driver driver, WebElementSource self, Class<ContainerClass> containerClass, Type[] genericTypes) {
        try {
            return (ContainerClass)this.initElementsContainer(driver, null, self, containerClass, genericTypes);
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to create elements container of type " + containerClass.getName(), e);
        }
    }

    default public <ContainerClass extends Container> List<ContainerClass> createElementsContainerList(Driver driver, By selector, Class<ContainerClass> listType, Type[] genericTypes) {
        BySelectorCollection collection = new BySelectorCollection(driver, null, selector);
        return new ElementsContainerCollection<ContainerClass>(this, driver, null, listType, genericTypes, collection);
    }

    default public <ContainerClass extends Container> List<ContainerClass> createElementsContainerList(Driver driver, Collection<? extends WebElement> elements, Class<ContainerClass> listType, Type[] genericTypes) {
        WebElementsCollectionWrapper collection = new WebElementsCollectionWrapper(driver, elements);
        return new ElementsContainerCollection<ContainerClass>(this, driver, null, listType, genericTypes, collection);
    }

    public Container initElementsContainer(Driver var1, @Nullable Field var2, WebElementSource var3, Class<?> var4, Type[] var5) throws ReflectiveOperationException;
}

