/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

@ParametersAreNonnullByDefault
public interface Driver {
    @CheckReturnValue
    @Nonnull
    public Config config();

    @CheckReturnValue
    @Nonnull
    public Browser browser();

    @CheckReturnValue
    public boolean hasWebDriverStarted();

    @CheckReturnValue
    @Nonnull
    public WebDriver getWebDriver();

    @Nonnull
    @CheckReturnValue
    public SelenideProxyServer getProxy();

    @CheckReturnValue
    @Nonnull
    public WebDriver getAndCheckWebDriver();

    @CheckReturnValue
    @Nullable
    public DownloadsFolder browserDownloadsFolder();

    public void close();

    @CheckReturnValue
    default public boolean supportsJavascript() {
        return this.hasWebDriverStarted() && JavaScript.asJsExecutor((SearchContext)this.getWebDriver()).isPresent();
    }

    default public <T> T executeJavaScript(String jsCode, Object ... arguments) {
        return (T)JavaScript.jsExecutor((SearchContext)this.getWebDriver()).executeScript(jsCode, arguments);
    }

    default public <T> T executeAsyncJavaScript(String jsCode, Object ... arguments) {
        return (T)JavaScript.jsExecutor((SearchContext)this.getWebDriver()).executeAsyncScript(jsCode, arguments);
    }

    default public void clearCookies() {
        if (this.hasWebDriverStarted()) {
            this.getWebDriver().manage().deleteAllCookies();
        }
    }

    @CheckReturnValue
    @Nonnull
    default public String getUserAgent() {
        return (String)this.executeJavaScript("return navigator.userAgent;", new Object[0]);
    }

    @CheckReturnValue
    @Nonnull
    default public String source() {
        return this.getWebDriver().getPageSource();
    }

    @CheckReturnValue
    @Nonnull
    default public String url() {
        return this.getWebDriver().getCurrentUrl();
    }

    @CheckReturnValue
    @Nonnull
    default public String getCurrentFrameUrl() {
        return this.executeJavaScript("return window.location.href", new Object[0]).toString();
    }

    @CheckReturnValue
    @Nonnull
    default public SelenideTargetLocator switchTo() {
        return new SelenideTargetLocator(this);
    }

    @CheckReturnValue
    @Nonnull
    default public Actions actions() {
        return new Actions(this.getWebDriver());
    }

    @CheckReturnValue
    @Nonnull
    default public SessionId getSessionId() {
        WebDriver driver = this.getWebDriver();
        if (driver instanceof WrapsDriver) {
            WrapsDriver wrapper = (WrapsDriver)driver;
            driver = wrapper.getWrappedDriver();
        }
        return ((RemoteWebDriver)driver).getSessionId();
    }

    default public boolean isLocalBrowser() {
        return this.config().remote() == null;
    }
}

