/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Ancestor;
import com.codeborne.selenide.commands.Append;
import com.codeborne.selenide.commands.As;
import com.codeborne.selenide.commands.CacheSelenideElement;
import com.codeborne.selenide.commands.Clear;
import com.codeborne.selenide.commands.Click;
import com.codeborne.selenide.commands.ContextClick;
import com.codeborne.selenide.commands.DescribeElement;
import com.codeborne.selenide.commands.DoubleClick;
import com.codeborne.selenide.commands.DownloadFile;
import com.codeborne.selenide.commands.DragAndDrop;
import com.codeborne.selenide.commands.Execute;
import com.codeborne.selenide.commands.Exists;
import com.codeborne.selenide.commands.Find;
import com.codeborne.selenide.commands.FindAll;
import com.codeborne.selenide.commands.FindAllByXpath;
import com.codeborne.selenide.commands.FindByXpath;
import com.codeborne.selenide.commands.GetAlias;
import com.codeborne.selenide.commands.GetAttribute;
import com.codeborne.selenide.commands.GetCssValue;
import com.codeborne.selenide.commands.GetDataAttribute;
import com.codeborne.selenide.commands.GetInnerHtml;
import com.codeborne.selenide.commands.GetInnerText;
import com.codeborne.selenide.commands.GetLastChild;
import com.codeborne.selenide.commands.GetName;
import com.codeborne.selenide.commands.GetOptions;
import com.codeborne.selenide.commands.GetOwnText;
import com.codeborne.selenide.commands.GetParent;
import com.codeborne.selenide.commands.GetPreceding;
import com.codeborne.selenide.commands.GetPseudoValue;
import com.codeborne.selenide.commands.GetSearchCriteria;
import com.codeborne.selenide.commands.GetSelectedOption;
import com.codeborne.selenide.commands.GetSelectedOptionText;
import com.codeborne.selenide.commands.GetSelectedOptionValue;
import com.codeborne.selenide.commands.GetSelectedOptions;
import com.codeborne.selenide.commands.GetSibling;
import com.codeborne.selenide.commands.GetText;
import com.codeborne.selenide.commands.GetValue;
import com.codeborne.selenide.commands.GetWrappedElement;
import com.codeborne.selenide.commands.Highlight;
import com.codeborne.selenide.commands.Hover;
import com.codeborne.selenide.commands.IsDisplayed;
import com.codeborne.selenide.commands.IsImage;
import com.codeborne.selenide.commands.Matches;
import com.codeborne.selenide.commands.Paste;
import com.codeborne.selenide.commands.Press;
import com.codeborne.selenide.commands.PressEnter;
import com.codeborne.selenide.commands.PressEscape;
import com.codeborne.selenide.commands.PressTab;
import com.codeborne.selenide.commands.ScrollIntoView;
import com.codeborne.selenide.commands.ScrollTo;
import com.codeborne.selenide.commands.SelectOptionByTextOrIndex;
import com.codeborne.selenide.commands.SelectOptionByValue;
import com.codeborne.selenide.commands.SelectOptionContainingText;
import com.codeborne.selenide.commands.SelectRadio;
import com.codeborne.selenide.commands.SetSelected;
import com.codeborne.selenide.commands.SetValue;
import com.codeborne.selenide.commands.Should;
import com.codeborne.selenide.commands.ShouldBe;
import com.codeborne.selenide.commands.ShouldHave;
import com.codeborne.selenide.commands.ShouldNot;
import com.codeborne.selenide.commands.ShouldNotBe;
import com.codeborne.selenide.commands.ShouldNotHave;
import com.codeborne.selenide.commands.TakeScreenshot;
import com.codeborne.selenide.commands.TakeScreenshotAsImage;
import com.codeborne.selenide.commands.ToString;
import com.codeborne.selenide.commands.ToWebElement;
import com.codeborne.selenide.commands.Type;
import com.codeborne.selenide.commands.Unfocus;
import com.codeborne.selenide.commands.UploadFile;
import com.codeborne.selenide.commands.UploadFileFromClasspath;
import com.codeborne.selenide.commands.Val;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Commands {
    private static Commands instance;
    private final Map<String, Command<?>> commands = new ConcurrentHashMap(128);

    public static synchronized Commands getInstance() {
        if (instance == null) {
            instance = Plugins.inject(Commands.class);
        }
        return instance;
    }

    protected Commands() {
        this.addFindCommands();
        this.addClickCommands();
        this.addModifyCommands();
        this.addInfoCommands();
        this.addSelectCommands();
        this.addKeyboardCommands();
        this.addActionsCommands();
        this.addShouldCommands();
        this.addShouldNotCommands();
        this.addFileCommands();
        this.addTechnicalCommands();
    }

    private void addTechnicalCommands() {
        this.add("as", new As());
        this.add("getAlias", new GetAlias());
        this.add("toString", new ToString());
        this.add("describe", new DescribeElement());
        this.add("toWebElement", new ToWebElement());
        this.add("getWrappedElement", new GetWrappedElement());
        this.add("cached", new CacheSelenideElement());
        this.add("screenshot", new TakeScreenshot());
        this.add("screenshotAsImage", new TakeScreenshotAsImage());
        this.add("getSearchCriteria", new GetSearchCriteria());
        this.add("execute", new Execute());
    }

    private void addActionsCommands() {
        this.add("dragAndDrop", new DragAndDrop());
        this.add("hover", new Hover());
        this.add("scrollTo", new ScrollTo());
        this.add("scrollIntoView", new ScrollIntoView());
        this.add("unfocus", new Unfocus());
    }

    private void addInfoCommands() {
        this.add("attr", new GetAttribute());
        this.add("getAttribute", new GetAttribute());
        this.add("getCssValue", new GetCssValue());
        this.add("data", new GetDataAttribute());
        this.add("exists", new Exists());
        this.add("getOwnText", new GetOwnText());
        this.add("innerText", new GetInnerText());
        this.add("innerHtml", new GetInnerHtml());
        this.add("has", new Matches());
        this.add("is", new Matches());
        this.add("isDisplayed", new IsDisplayed());
        this.add("isImage", new IsImage());
        this.add("getText", new GetText());
        this.add("name", new GetName());
        this.add("text", new GetText());
        this.add("getValue", new GetValue());
        this.add("pseudo", new GetPseudoValue());
        this.add("highlight", new Highlight());
    }

    private void addClickCommands() {
        this.add("click", new Click());
        this.add("contextClick", new ContextClick());
        this.add("doubleClick", new DoubleClick());
    }

    private void addModifyCommands() {
        this.add("selectRadio", new SelectRadio());
        this.add("setSelected", new SetSelected());
        this.add("setValue", new SetValue());
        this.add("val", new Val());
        this.add("append", new Append());
        this.add("paste", new Paste());
        this.add("clear", Plugins.inject(Clear.class));
        this.add("type", new Type());
    }

    private void addFindCommands() {
        this.add("find", new Find());
        this.add("$", new Find());
        this.add("$x", new FindByXpath());
        this.add("findAll", new FindAll());
        this.add("$$", new FindAll());
        this.add("$$x", new FindAllByXpath());
        this.add("ancestor", new Ancestor());
        this.add("closest", new Ancestor());
        this.add("parent", new GetParent());
        this.add("sibling", new GetSibling());
        this.add("preceding", new GetPreceding());
        this.add("lastChild", new GetLastChild());
    }

    private void addKeyboardCommands() {
        this.add("pressEnter", new PressEnter());
        this.add("pressEscape", new PressEscape());
        this.add("pressTab", new PressTab());
        this.add("press", new Press());
    }

    private void addSelectCommands() {
        this.add("getOptions", new GetOptions());
        this.add("getSelectedOption", new GetSelectedOption());
        this.add("getSelectedOptions", new GetSelectedOptions());
        this.add("getSelectedOptionText", new GetSelectedOptionText());
        this.add("getSelectedOptionValue", new GetSelectedOptionValue());
        this.add("selectOption", new SelectOptionByTextOrIndex());
        this.add("selectOptionContainingText", new SelectOptionContainingText());
        this.add("selectOptionByValue", new SelectOptionByValue());
    }

    private void addFileCommands() {
        this.add("download", new DownloadFile());
        this.add("uploadFile", new UploadFile());
        this.add("uploadFromClasspath", new UploadFileFromClasspath());
    }

    private void addShouldNotCommands() {
        this.add("shouldNot", new ShouldNot());
        this.add("shouldNotHave", new ShouldNotHave());
        this.add("shouldNotBe", new ShouldNotBe());
    }

    private void addShouldCommands() {
        this.add("should", new Should());
        this.add("shouldHave", new ShouldHave());
        this.add("shouldBe", new ShouldBe());
    }

    public final void add(String method, Command<?> command) {
        this.commands.put(method, command);
    }

    @Nullable
    public <T> T execute(Object proxy, WebElementSource webElementSource, String methodName, @Nullable Object[] args) {
        Command<T> command = this.getCommand(methodName);
        return command.execute((SelenideElement)proxy, webElementSource, args);
    }

    @CheckReturnValue
    @Nonnull
    private <T> Command<T> getCommand(String methodName) {
        Command<?> command = this.commands.get(methodName);
        if (command == null) {
            throw new IllegalArgumentException("Unknown Selenide method: " + methodName);
        }
        return command;
    }
}

