/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.datetime;

import com.codeborne.selenide.conditions.datetime.DateBetween;
import com.codeborne.selenide.conditions.datetime.DateEquals;
import com.codeborne.selenide.conditions.datetime.DateFormatCondition;
import com.codeborne.selenide.conditions.datetime.TemporalCondition;
import com.codeborne.selenide.conditions.datetime.TemporalFormatCondition;
import java.time.LocalDate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DateConditions {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd";

    @Nonnull
    @CheckReturnValue
    public static TemporalCondition<LocalDate> date(LocalDate date) {
        return DateConditions.date(date, DEFAULT_PATTERN);
    }

    @Nonnull
    @CheckReturnValue
    public static TemporalCondition<LocalDate> date(LocalDate date, String pattern) {
        return new DateEquals(date, new DateFormatCondition(pattern));
    }

    @Nonnull
    @CheckReturnValue
    public static TemporalCondition<LocalDate> dateBetween(LocalDate from, LocalDate until) {
        return DateConditions.dateBetween(from, until, DEFAULT_PATTERN);
    }

    @Nonnull
    @CheckReturnValue
    public static TemporalCondition<LocalDate> dateBetween(LocalDate from, LocalDate until, String pattern) {
        return new DateBetween(from, until, new DateFormatCondition(pattern));
    }

    @Nonnull
    @CheckReturnValue
    public static TemporalFormatCondition<LocalDate> dateFormat(String pattern) {
        return new DateFormatCondition(pattern);
    }
}

