/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.datetime;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.conditions.datetime.TemporalFormatCondition;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class TemporalCondition<T extends TemporalAccessor>
extends WebElementCondition {
    private final TemporalFormatCondition<T> formatCondition;

    protected TemporalCondition(String name, TemporalFormatCondition<T> format) {
        super(name);
        this.formatCondition = format;
    }

    protected abstract boolean matches(T var1);

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        CheckResult formatted = this.formatCondition.check(driver, element);
        return switch (formatted.verdict()) {
            default -> throw new IncompatibleClassChangeError();
            case CheckResult.Verdict.REJECT -> formatted;
            case CheckResult.Verdict.ACCEPT -> {
                TemporalAccessor localDateValue = Objects.requireNonNull((TemporalAccessor)formatted.getActualValue(), "Format condition returns null, not date");
                yield new CheckResult(this.matches(localDateValue), (Object)this.formatCondition.format(localDateValue));
            }
        };
    }

    protected final String format(T date) {
        return this.formatCondition.format(date);
    }
}

