/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.ex.FileNotDownloadedError;
import com.codeborne.selenide.files.DownloadAction;
import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Downloader;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import java.io.File;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v122.browser.Browser;
import org.openqa.selenium.devtools.v122.browser.model.DownloadProgress;
import org.openqa.selenium.devtools.v122.browser.model.DownloadWillBegin;
import org.openqa.selenium.devtools.v122.page.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DownloadFileWithCdp {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileWithCdp.class);
    private static final AtomicLong SEQUENCE = new AtomicLong();
    protected final Downloader downloader;

    DownloadFileWithCdp(Downloader downloader) {
        this.downloader = downloader;
    }

    public DownloadFileWithCdp() {
        this(new Downloader());
    }

    @Nullable
    protected DownloadsFolder getDownloadsFolder(Driver driver) {
        return driver.browserDownloadsFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    @Nonnull
    public File download(WebElementSource anyClickableElement, WebElement clickable, long timeout, long incrementTimeout, FileFilter fileFilter, DownloadAction action) {
        Driver driver = anyClickableElement.driver();
        DevTools devTools = this.initDevTools(driver);
        DownloadsFolder downloadsFolder = Objects.requireNonNull(this.getDownloadsFolder(driver), "Webdriver downloads folder is not configured");
        CdpDownloads downloads = new CdpDownloads(downloadsFolder, new ConcurrentHashMap<String, CdpDownload>(1));
        this.prepareDownloadWithCdp(driver, devTools, downloads, timeout);
        action.perform(anyClickableElement.driver(), clickable);
        try {
            File file = this.waitUntilDownloadsCompleted(anyClickableElement.driver(), fileFilter, timeout, incrementTimeout, downloads);
            if (!fileFilter.match(new DownloadedFile(file, Collections.emptyMap()))) {
                String message = String.format("Failed to download file%s in %d ms.%s;%n actually downloaded: %s", fileFilter.description(), timeout, fileFilter.description(), file.getAbsolutePath());
                throw new FileNotDownloadedError(driver, message, timeout);
            }
            File file2 = this.archiveFile(anyClickableElement.driver(), file);
            return file2;
        }
        finally {
            devTools.clearListeners();
        }
    }

    @Nonnull
    protected File archiveFile(Driver driver, File downloadedFile) {
        File uniqueFolder = this.downloader.prepareTargetFolder(driver.config());
        File archivedFile = new File(uniqueFolder, downloadedFile.getName());
        FileHelper.moveFile(downloadedFile, archivedFile);
        log.debug("Moved the downloaded file {} to {}", (Object)downloadedFile, (Object)archivedFile);
        return archivedFile;
    }

    private File waitUntilDownloadsCompleted(Driver driver, FileFilter fileFilter, long timeout, long incrementTimeout, CdpDownloads downloads) {
        long pollingInterval = Math.max(driver.config().pollingInterval(), 100L);
        long downloadStartedAt = System.currentTimeMillis();
        Stopwatch stopwatch = new Stopwatch(timeout);
        do {
            Optional<CdpDownload> downloadedFile;
            if ((downloadedFile = downloads.find(fileFilter)).isPresent()) {
                log.debug("File {} download is complete after {} ms.", (Object)downloadedFile.get().fileName, (Object)stopwatch.getElapsedTimeMs());
                return downloadedFile.get().file();
            }
            this.failFastIfNoChanges(driver, downloads, fileFilter, downloadStartedAt, timeout, incrementTimeout);
            stopwatch.sleep(pollingInterval);
        } while (!stopwatch.isTimeoutReached());
        String message = "Failed to download file%s in %d ms.".formatted(fileFilter.description(), timeout);
        throw new FileNotDownloadedError(driver, message, timeout);
    }

    private DevTools initDevTools(Driver driver) {
        Optional<HasDevTools> cdpBrowser;
        if (driver.browser().isChromium() && (cdpBrowser = WebdriverUnwrapper.cast((SearchContext)driver.getWebDriver(), HasDevTools.class)).isPresent()) {
            DevTools devTools = cdpBrowser.get().getDevTools();
            devTools.createSessionIfThereIsNotOne();
            devTools.send(Page.enable());
            return devTools;
        }
        throw new IllegalArgumentException("The browser you selected \"%s\" doesn't have Chrome Devtools protocol functionality.".formatted(driver.browser().name));
    }

    private void prepareDownloadWithCdp(Driver driver, DevTools devTools, CdpDownloads downloads, long timeout) {
        devTools.send(Browser.setDownloadBehavior((Browser.SetDownloadBehaviorBehavior)Browser.SetDownloadBehaviorBehavior.DEFAULT, Optional.empty(), Optional.empty(), Optional.of(true)));
        log.debug("clear devtools listeners");
        devTools.clearListeners();
        log.debug("add devtools listener for 'downloadWillBegin'");
        devTools.addListener(Browser.downloadWillBegin(), (Consumer)new DownloadWillBeginListener(DownloadFileWithCdp.id(), downloads));
        log.debug("add devtools listener for 'downloadProgress'");
        devTools.addListener(Browser.downloadProgress(), (Consumer)new DownloadProgressListener(DownloadFileWithCdp.id(), driver, downloads, timeout));
    }

    private static long id() {
        return SEQUENCE.incrementAndGet();
    }

    private void failFastIfNoChanges(Driver driver, CdpDownloads downloads, FileFilter filter, long downloadStartedAt, long timeout, long incrementTimeout) {
        long lastModifiedAt;
        long now = System.currentTimeMillis();
        long filesHasNotBeenUpdatedForMs = now - (lastModifiedAt = downloads.lastModificationTime().orElse(downloadStartedAt).longValue());
        if (filesHasNotBeenUpdatedForMs > incrementTimeout) {
            String message = String.format("Failed to download file%s in %d ms: files in %s haven't been modified for %s ms. (lastUpdate: %s, now: %s, incrementTimeout: %s)", filter.description(), timeout, downloads.folder, filesHasNotBeenUpdatedForMs, lastModifiedAt, now, incrementTimeout);
            throw new FileNotDownloadedError(driver, message, timeout);
        }
    }

    private record CdpDownloads(DownloadsFolder folder, ConcurrentMap<String, CdpDownload> downloads) {
        private Optional<CdpDownload> find(FileFilter fileFilter) {
            return this.downloads.values().stream().filter(download -> download.completed).filter(download -> fileFilter.match(download.file())).findAny();
        }

        private Optional<Long> lastModificationTime() {
            return this.downloads.values().stream().map(download -> download.lastModifiedAt).max(Long::compare);
        }

        private void addFile(String guid, String fileName) {
            this.downloads.put(guid, new CdpDownload(this.folder, fileName));
        }

        public void inProgress(String guid) {
            ((CdpDownload)this.downloads.get((Object)guid)).lastModifiedAt = System.currentTimeMillis();
        }

        public void finish(String guid) {
            ((CdpDownload)this.downloads.get((Object)guid)).completed = true;
        }
    }

    private static class CdpDownload {
        private final DownloadsFolder folder;
        private final String fileName;
        private long lastModifiedAt = System.currentTimeMillis();
        private boolean completed;

        private CdpDownload(DownloadsFolder folder, String fileName) {
            this.folder = folder;
            this.fileName = fileName;
        }

        private File file() {
            return new File(this.folder.getPath(), this.fileName);
        }
    }

    private record DownloadWillBeginListener(long id, CdpDownloads downloads) implements Consumer<DownloadWillBegin>
    {
        @Override
        public void accept(DownloadWillBegin e) {
            log.debug("[{}] Download will begin with suggested file name \"{}\" (url: \"{}\", frameId: {}, guid: {})", new Object[]{this.id, e.getSuggestedFilename(), e.getUrl(), e.getFrameId(), e.getGuid()});
            this.downloads.addFile(e.getGuid(), e.getSuggestedFilename());
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "#" + this.id;
        }
    }

    private record DownloadProgressListener(long id, Driver driver, CdpDownloads downloads, long timeout) implements Consumer<DownloadProgress>
    {
        @Override
        public void accept(DownloadProgress e) {
            log.debug("[{}] Download is {} (received bytes: {}, total bytes: {}, guid: {})", new Object[]{this.id, e.getState(), e.getReceivedBytes(), e.getTotalBytes(), e.getGuid()});
            switch (e.getState()) {
                case CANCELED: {
                    String message = "File download is %s (received bytes: %s, total bytes: %s, guid: %s)".formatted(e.getState(), e.getReceivedBytes(), e.getTotalBytes(), e.getGuid());
                    throw new FileNotDownloadedError(this.driver, message, this.timeout);
                }
                case COMPLETED: {
                    this.downloads.finish(e.getGuid());
                    break;
                }
                case INPROGRESS: {
                    this.downloads.inProgress(e.getGuid());
                }
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "#" + this.id;
        }
    }
}

