/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebdriverUnwrapper {
    public static <T> boolean instanceOf(Driver driver, Class<T> klass) {
        return WebdriverUnwrapper.cast(driver, klass).isPresent();
    }

    public static <T> boolean instanceOf(SearchContext driver, Class<T> klass) {
        return WebdriverUnwrapper.cast(driver, klass).isPresent();
    }

    public static <T> Optional<T> cast(Driver driver, Class<T> klass) {
        return WebdriverUnwrapper.cast((SearchContext)driver.getWebDriver(), klass);
    }

    public static <T> Optional<T> cast(SearchContext driverOrElement, Class<T> klass) {
        WebDriver webdriver = WebdriverUnwrapper.unwrap(driverOrElement);
        return webdriver != null && klass.isAssignableFrom(webdriver.getClass()) ? Optional.of(webdriver) : Optional.empty();
    }

    public static <T> T cast(WebElement probablyWrappedWebElement, Class<T> klass) {
        WebElement unwrappedWebElement = probablyWrappedWebElement;
        while (unwrappedWebElement instanceof WrapsElement) {
            WrapsElement wrapper = (WrapsElement)unwrappedWebElement;
            unwrappedWebElement = wrapper.getWrappedElement();
        }
        if (!klass.isAssignableFrom(unwrappedWebElement.getClass())) {
            throw new IllegalArgumentException("WebElement " + unwrappedWebElement + " is not instance of " + klass.getName());
        }
        return (T)unwrappedWebElement;
    }

    @Nullable
    @CheckReturnValue
    public static WebDriver unwrap(SearchContext driverOrElement) {
        if (driverOrElement instanceof WrapsDriver) {
            WrapsDriver wrapper = (WrapsDriver)driverOrElement;
            return WebdriverUnwrapper.unwrap((SearchContext)wrapper.getWrappedDriver());
        }
        try {
            if (driverOrElement instanceof RemoteWebDriver) {
                RemoteWebDriver remoteWebDriver = (RemoteWebDriver)driverOrElement;
                return new Augmenter().augment((WebDriver)remoteWebDriver);
            }
        }
        catch (IllegalStateException e) {
            return (WebDriver)driverOrElement;
        }
        return null;
    }

    @Nonnull
    @CheckReturnValue
    public static RemoteWebDriver unwrapRemoteWebDriver(WebDriver driver) {
        RemoteWebDriver remoteWebDriver;
        if (driver instanceof WrapsDriver) {
            WrapsDriver wrapper = (WrapsDriver)driver;
            remoteWebDriver = (RemoteWebDriver)wrapper.getWrappedDriver();
        } else {
            remoteWebDriver = (RemoteWebDriver)driver;
        }
        return remoteWebDriver;
    }
}

