/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.WebElementSource;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Click
implements Command<Void> {
    @Override
    @Nullable
    public Void execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        if (args == null || args.length == 0) {
            this.click(locator.driver(), locator.findAndAssertElementIsInteractable());
        } else if (args.length == 2) {
            Integer offsetX = (Integer)Util.firstOf(args);
            Integer offsetY = (Integer)args[1];
            this.click(locator.driver(), locator.findAndAssertElementIsInteractable(), offsetX, offsetY);
        }
        return null;
    }

    protected void click(Driver driver, WebElement element) {
        if (driver.config().clickViaJs()) {
            this.click(driver, element, 0, 0);
        } else {
            element.click();
        }
    }

    protected void click(Driver driver, WebElement element, int offsetX, int offsetY) {
        if (driver.config().clickViaJs()) {
            driver.executeJavaScript("var rect = arguments[0].getBoundingClientRect();arguments[0].dispatchEvent(new MouseEvent('click', { 'view': window, 'bubbles': true, 'cancelable': true, 'clientX': rect.left + rect.width/2 + arguments[1], 'clientY': rect.top + rect.height/2 + arguments[2]}))", element, offsetX, offsetY);
        } else {
            driver.actions().moveToElement(element, offsetX, offsetY).click().build().perform();
        }
    }
}

