/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.File;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class UploadFile
implements Command<File> {
    @Override
    @CheckReturnValue
    @Nonnull
    public File execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) throws IOException {
        File[] file = this.getFiles(args);
        this.checkFilesGiven(file);
        this.checkFilesExist(file);
        WebElement inputField = locator.getWebElement();
        Driver driver = locator.driver();
        this.checkValidInputField(driver, inputField);
        String fileNames = Stream.of(file).map(this::canonicalPath).collect(Collectors.joining("\n"));
        this.uploadFiles(driver.config(), inputField, fileNames);
        return file[0].getCanonicalFile();
    }

    private void checkFilesGiven(File[] file) {
        if (file.length == 0) {
            throw new IllegalArgumentException("No files to upload");
        }
    }

    private void checkFilesExist(File[] file) {
        for (File f : file) {
            if (f.exists()) continue;
            throw new IllegalArgumentException("File not found: " + f.getAbsolutePath());
        }
    }

    @CheckReturnValue
    @Nonnull
    private File[] getFiles(@Nullable Object[] args) {
        return args instanceof File[] ? (File[])args : (File[])Util.firstOf(args);
    }

    private String canonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot get canonical path of file " + file, e);
        }
    }

    protected void uploadFiles(Config config, WebElement inputField, String fileNames) {
        Stopwatch stopwatch = new Stopwatch(config.timeout());
        while (true) {
            try {
                inputField.sendKeys(new CharSequence[]{fileNames});
            }
            catch (ElementNotInteractableException notInteractable) {
                if (stopwatch.isTimeoutReached()) {
                    throw notInteractable;
                }
                stopwatch.sleep(config.pollingInterval());
                if (!stopwatch.isTimeoutReached()) continue;
            }
            break;
        }
    }

    private void checkValidInputField(Driver driver, WebElement inputField) {
        if (!"input".equalsIgnoreCase(inputField.getTagName())) {
            throw new IllegalArgumentException("Cannot upload file because " + Describe.describe(driver, inputField) + " is not an INPUT");
        }
    }
}

