/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.WebElementSelector;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class BySelectorCollection
implements WebElementsCollection {
    private final Driver driver;
    private final SearchContext parent;
    private final By selector;

    public BySelectorCollection(Driver driver, By selector) {
        this(driver, null, selector);
    }

    public BySelectorCollection(Driver driver, @Nullable SearchContext parent, By selector) {
        this.driver = driver;
        this.parent = parent;
        this.selector = selector;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        SearchContext searchContext = this.parent == null ? this.driver.getWebDriver() : this.parent;
        return WebElementSelector.instance.findElements(this.driver, searchContext, this.selector);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.parent == null ? Describe.selector(this.selector) : (this.parent instanceof SelenideElement ? ((SelenideElement)this.parent).getSearchCriteria() + "/" + Describe.shortly(this.selector) : Describe.shortly(this.selector));
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }
}

