/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.Cleanup;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class Describe {
    private static final Logger log = LoggerFactory.getLogger(Describe.class);
    private final Driver driver;
    private final WebElement element;
    private final StringBuilder sb = new StringBuilder();

    private Describe(Driver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
        this.sb.append('<').append(element.getTagName());
    }

    private Describe appendAttributes() {
        block4: {
            try {
                if (this.supportsJavascriptAttributes()) {
                    return this.appendAllAttributes();
                }
            }
            catch (UnsupportedOperationException | NoSuchElementException | StaleElementReferenceException | UnsupportedCommandException throwable) {
            }
            catch (WebDriverException probablyBrowserDoesNotSupportJavaScript) {
                if (probablyBrowserDoesNotSupportJavaScript.getMessage().toLowerCase().contains("method is not implemented")) break block4;
                log.warn("Failed to get attributes via JS: {}", (Object)probablyBrowserDoesNotSupportJavaScript.toString());
            }
        }
        return this.appendPredefinedAttributes();
    }

    private Describe appendAllAttributes() {
        Map map = (Map)this.driver.executeJavaScript("var s = {};var attrs = arguments[0].attributes;for (var i = 0; i < attrs.length; i++) {   var a = attrs[i];    if (a.name != 'style') {     s[a.name] = a.value;   }}return s;", this.element);
        TreeMap<String, String> sortedByName = new TreeMap<String, String>();
        if (map != null) {
            sortedByName.putAll(map);
        }
        sortedByName.put("value", this.element.getAttribute("value"));
        if (!sortedByName.containsKey("type")) {
            sortedByName.put("type", this.element.getAttribute("type"));
        }
        for (Map.Entry entry : sortedByName.entrySet()) {
            this.attr((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    private Describe appendPredefinedAttributes() {
        return this.attr("class").attr("disabled").attr("readonly").attr("href").attr("id").attr("name").attr("onclick").attr("onchange").attr("placeholder").attr("type").attr("value");
    }

    private boolean supportsJavascriptAttributes() {
        return this.driver.supportsJavascript();
    }

    private Describe attr(String attributeName) {
        try {
            String attributeValue = this.element.getAttribute(attributeName);
            return this.attr(attributeName, attributeValue);
        }
        catch (UnsupportedOperationException | NoSuchElementException | StaleElementReferenceException | UnsupportedCommandException browserDoesNotSupportJavaScript) {
            return this;
        }
        catch (WebDriverException probablyBrowserDoesNotSupportJavaScript) {
            if (!probablyBrowserDoesNotSupportJavaScript.getMessage().toLowerCase().contains("method is not implemented")) {
                log.warn("Failed to get attribute {}: {}", (Object)attributeName, (Object)probablyBrowserDoesNotSupportJavaScript.toString());
            }
            return this;
        }
    }

    private Describe attr(String attributeName, @Nullable String attributeValue) {
        if (attributeValue != null) {
            if (attributeValue.length() > 0) {
                this.sb.append(' ').append(attributeName).append("=\"").append(attributeValue).append('\"');
            } else {
                this.sb.append(' ').append(attributeName);
            }
        }
        return this;
    }

    private String serialize() {
        String text = this.safeCall("text", () -> ((WebElement)this.element).getText());
        this.sb.append('>').append(text == null ? "" : text).append("</").append(this.safeCall("tagName", () -> ((WebElement)this.element).getTagName())).append('>');
        return this.sb.toString();
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return this.sb.toString();
    }

    private String flush() {
        return this.sb.append('>').toString();
    }

    @CheckReturnValue
    @Nonnull
    public static String describe(Driver driver, @Nullable WebElement element) {
        try {
            if (element == null) {
                return "null";
            }
            return new Describe(driver, element).appendAttributes().isSelected(element).isDisplayed(element).serialize();
        }
        catch (WebDriverException elementDoesNotExist) {
            return Describe.failedToDescribe(Cleanup.of.webdriverExceptionMessage(elementDoesNotExist));
        }
        catch (RuntimeException e) {
            return Describe.failedToDescribe(e.toString());
        }
    }

    @CheckReturnValue
    @Nonnull
    static String shortly(Driver driver, @Nonnull WebElement element) {
        try {
            if (element == null) {
                return "null";
            }
            if (element instanceof SelenideElement) {
                return Describe.shortly(driver, ((SelenideElement)element).toWebElement());
            }
            return new Describe(driver, element).attr("id").attr("name").flush();
        }
        catch (WebDriverException elementDoesNotExist) {
            return Describe.failedToDescribe(Cleanup.of.webdriverExceptionMessage(elementDoesNotExist));
        }
        catch (RuntimeException e) {
            return Describe.failedToDescribe(e.toString());
        }
    }

    @Nonnull
    private static String failedToDescribe(String s2) {
        return "Ups, failed to described the element [caused by: " + s2 + ']';
    }

    private Describe isSelected(WebElement element) {
        try {
            if (element.isSelected()) {
                this.sb.append(' ').append("selected:true");
            }
        }
        catch (UnsupportedOperationException | WebDriverException throwable) {
            // empty catch block
        }
        return this;
    }

    private Describe isDisplayed(WebElement element) {
        try {
            if (!element.isDisplayed()) {
                this.sb.append(' ').append("displayed:false");
            }
        }
        catch (UnsupportedOperationException | WebDriverException e) {
            log.debug("Failed to check visibility", e);
            this.sb.append(' ').append("displayed:").append(Cleanup.of.webdriverExceptionMessage(e));
        }
        catch (RuntimeException e) {
            log.error("Failed to check visibility", (Throwable)e);
            this.sb.append(' ').append("displayed:").append(Cleanup.of.webdriverExceptionMessage(e));
        }
        return this;
    }

    @CheckReturnValue
    @Nonnull
    static String shortly(By selector) {
        if (selector instanceof By.ByCssSelector) {
            return selector.toString().replaceFirst("By\\.selector:\\s*(.*)", "$1").replaceFirst("By\\.cssSelector:\\s*(.*)", "$1");
        }
        return selector.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static String selector(By selector) {
        return selector.toString().replaceFirst("By\\.selector:\\s*", "").replaceFirst("By\\.cssSelector:\\s*", "");
    }

    private String safeCall(String name, Supplier<String> method) {
        try {
            return method.get();
        }
        catch (WebDriverException e) {
            log.debug("Failed to get {}", (Object)name, (Object)e);
            return Cleanup.of.webdriverExceptionMessage(e);
        }
        catch (RuntimeException e) {
            log.error("Failed to get {}", (Object)name, (Object)e);
            return "?";
        }
    }
}

