/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.Randomizer;
import java.io.File;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Downloader {
    private final Randomizer random;

    public Downloader() {
        this(new Randomizer());
    }

    public Downloader(Randomizer random) {
        this.random = random;
    }

    @CheckReturnValue
    @Nonnull
    public String randomFileName() {
        return this.random.text();
    }

    @CheckReturnValue
    @Nonnull
    public File prepareTargetFile(Config config, String fileName) {
        File uniqueFolder = this.prepareTargetFolder(config);
        return new File(uniqueFolder, fileName);
    }

    @Nonnull
    public File prepareTargetFolder(Config config) {
        File uniqueFolder = new File(config.downloadsFolder(), this.random.text());
        if (uniqueFolder.exists()) {
            throw new IllegalStateException("Unbelievable! Unique folder already exists: " + uniqueFolder.getAbsolutePath());
        }
        FileHelper.ensureFolderExists(uniqueFolder);
        return uniqueFolder;
    }
}

