/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class FilteringCollection
implements WebElementsCollection {
    private final WebElementsCollection originalCollection;
    private final Condition filter;

    public FilteringCollection(WebElementsCollection originalCollection, Condition filter) {
        this.originalCollection = originalCollection;
        this.filter = filter;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        return this.originalCollection.getElements().stream().filter(webElement -> this.filter.apply(this.originalCollection.driver(), (WebElement)webElement)).collect(Collectors.toList());
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.originalCollection.description() + ".filter(" + this.filter + ')';
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.originalCollection.driver();
    }
}

