/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class TailOfCollection
implements WebElementsCollection {
    private final WebElementsCollection originalCollection;
    private final int size;

    public TailOfCollection(WebElementsCollection originalCollection, int size) {
        this.originalCollection = originalCollection;
        this.size = size;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        List<WebElement> source = this.originalCollection.getElements();
        return source.subList(source.size() - Math.min(source.size(), this.size), source.size());
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.originalCollection.description() + ":last(" + this.size + ')';
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.originalCollection.driver();
    }
}

