/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.impl.Html;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class TextsInAnyOrder
extends ExactTexts {
    public TextsInAnyOrder(String ... expectedTexts) {
        super(expectedTexts);
    }

    public TextsInAnyOrder(List<String> expectedTexts) {
        super(expectedTexts);
    }

    @Override
    public boolean test(List<WebElement> elements) {
        if (elements.size() != this.expectedTexts.size()) {
            return false;
        }
        for (String expectedText : this.expectedTexts) {
            boolean found = false;
            for (WebElement element : elements) {
                if (!Html.text.contains(element.getText(), expectedText)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "TextsInAnyOrder " + this.expectedTexts;
    }
}

