/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.SelenideFieldDecorator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

@ParametersAreNonnullByDefault
public class SelenidePageFactory {
    @CheckReturnValue
    @Nonnull
    public <PageObjectClass> PageObjectClass page(Driver driver, Class<PageObjectClass> pageObjectClass) {
        try {
            Constructor<PageObjectClass> constructor = pageObjectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return this.page(driver, constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create new instance of " + pageObjectClass, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public <PageObjectClass, T extends PageObjectClass> PageObjectClass page(Driver driver, T pageObject) {
        this.initElements((FieldDecorator)new SelenideFieldDecorator(this, driver, (SearchContext)driver.getWebDriver()), pageObject);
        return pageObject;
    }

    public void initElements(FieldDecorator decorator, Object page) {
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            this.proxyFields(decorator, page, proxyIn);
        }
    }

    private void proxyFields(FieldDecorator decorator, Object page, Class<?> proxyIn) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            Object value;
            if (this.isInitialized(page, field) || (value = decorator.decorate(page.getClass().getClassLoader(), field)) == null) continue;
            try {
                field.setAccessible(true);
                field.set(page, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isInitialized(Object page, Field field) {
        try {
            field.setAccessible(true);
            return field.get(page) != null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

